/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.typesafe.config.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oadd.com.typesafe.config.ConfigException;
import oadd.com.typesafe.config.ConfigMergeable;
import oadd.com.typesafe.config.ConfigObject;
import oadd.com.typesafe.config.ConfigOrigin;
import oadd.com.typesafe.config.ConfigRenderOptions;
import oadd.com.typesafe.config.ConfigValue;
import oadd.com.typesafe.config.ConfigValueType;
import oadd.com.typesafe.config.impl.AbstractConfigValue;
import oadd.com.typesafe.config.impl.ConfigDelayedMergeObject;
import oadd.com.typesafe.config.impl.ConfigImpl;
import oadd.com.typesafe.config.impl.Path;
import oadd.com.typesafe.config.impl.ResolveContext;
import oadd.com.typesafe.config.impl.ResolveStatus;
import oadd.com.typesafe.config.impl.SimpleConfig;
import oadd.com.typesafe.config.impl.SimpleConfigOrigin;

abstract class AbstractConfigObject
extends AbstractConfigValue
implements ConfigObject {
    private final SimpleConfig config = new SimpleConfig(this);

    protected AbstractConfigObject(ConfigOrigin configOrigin) {
        super(configOrigin);
    }

    @Override
    public SimpleConfig toConfig() {
        return this.config;
    }

    @Override
    public AbstractConfigObject toFallbackValue() {
        return this;
    }

    @Override
    public abstract AbstractConfigObject withOnlyKey(String var1);

    @Override
    public abstract AbstractConfigObject withoutKey(String var1);

    @Override
    public abstract AbstractConfigObject withValue(String var1, ConfigValue var2);

    protected abstract AbstractConfigObject withOnlyPathOrNull(Path var1);

    abstract AbstractConfigObject withOnlyPath(Path var1);

    abstract AbstractConfigObject withoutPath(Path var1);

    abstract AbstractConfigObject withValue(Path var1, ConfigValue var2);

    protected final AbstractConfigValue peekAssumingResolved(String string, Path path) {
        try {
            return this.attemptPeekWithPartialResolve(string);
        }
        catch (ConfigException.NotResolved notResolved) {
            throw ConfigImpl.improveNotResolved(path, notResolved);
        }
    }

    protected abstract AbstractConfigValue attemptPeekWithPartialResolve(String var1);

    protected AbstractConfigValue peekPath(Path path, ResolveContext resolveContext) throws AbstractConfigValue.NotPossibleToResolve {
        return AbstractConfigObject.peekPath(this, path, resolveContext);
    }

    AbstractConfigValue peekPath(Path path) {
        try {
            return AbstractConfigObject.peekPath(this, path, null);
        }
        catch (AbstractConfigValue.NotPossibleToResolve notPossibleToResolve) {
            throw new ConfigException.BugOrBroken("NotPossibleToResolve happened though we had no ResolveContext in peekPath");
        }
    }

    private static AbstractConfigValue peekPath(AbstractConfigObject abstractConfigObject, Path path, ResolveContext resolveContext) throws AbstractConfigValue.NotPossibleToResolve {
        try {
            if (resolveContext != null) {
                AbstractConfigValue abstractConfigValue = resolveContext.restrict(path).resolve(abstractConfigObject);
                if (abstractConfigValue instanceof AbstractConfigObject) {
                    return AbstractConfigObject.peekPath((AbstractConfigObject)abstractConfigValue, path, null);
                }
                throw new ConfigException.BugOrBroken("resolved object to non-object " + abstractConfigObject + " to " + abstractConfigValue);
            }
            Path path2 = path.remainder();
            AbstractConfigValue abstractConfigValue = abstractConfigObject.attemptPeekWithPartialResolve(path.first());
            if (path2 == null) {
                return abstractConfigValue;
            }
            if (abstractConfigValue instanceof AbstractConfigObject) {
                return AbstractConfigObject.peekPath((AbstractConfigObject)abstractConfigValue, path2, null);
            }
            return null;
        }
        catch (ConfigException.NotResolved notResolved) {
            throw ConfigImpl.improveNotResolved(path, notResolved);
        }
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.OBJECT;
    }

    protected abstract AbstractConfigObject newCopy(ResolveStatus var1, ConfigOrigin var2);

    @Override
    protected AbstractConfigObject newCopy(ConfigOrigin configOrigin) {
        return this.newCopy(this.resolveStatus(), configOrigin);
    }

    @Override
    protected AbstractConfigObject constructDelayedMerge(ConfigOrigin configOrigin, List<AbstractConfigValue> list) {
        return new ConfigDelayedMergeObject(configOrigin, list);
    }

    @Override
    protected abstract AbstractConfigObject mergedWithObject(AbstractConfigObject var1);

    @Override
    public AbstractConfigObject withFallback(ConfigMergeable configMergeable) {
        return (AbstractConfigObject)super.withFallback(configMergeable);
    }

    static ConfigOrigin mergeOrigins(Collection<? extends AbstractConfigValue> collection) {
        if (collection.isEmpty()) {
            throw new ConfigException.BugOrBroken("can't merge origins on empty list");
        }
        ArrayList<SimpleConfigOrigin> arrayList = new ArrayList<SimpleConfigOrigin>();
        SimpleConfigOrigin simpleConfigOrigin = null;
        int n = 0;
        for (AbstractConfigValue abstractConfigValue : collection) {
            if (simpleConfigOrigin == null) {
                simpleConfigOrigin = abstractConfigValue.origin();
            }
            if (abstractConfigValue instanceof AbstractConfigObject && ((AbstractConfigObject)abstractConfigValue).resolveStatus() == ResolveStatus.RESOLVED && ((ConfigObject)((Object)abstractConfigValue)).isEmpty()) continue;
            arrayList.add(abstractConfigValue.origin());
            ++n;
        }
        if (n == 0) {
            arrayList.add(simpleConfigOrigin);
        }
        return SimpleConfigOrigin.mergeOrigins(arrayList);
    }

    static ConfigOrigin mergeOrigins(AbstractConfigObject ... abstractConfigObjectArray) {
        return AbstractConfigObject.mergeOrigins(Arrays.asList(abstractConfigObjectArray));
    }

    @Override
    abstract AbstractConfigObject resolveSubstitutions(ResolveContext var1) throws AbstractConfigValue.NotPossibleToResolve;

    @Override
    abstract AbstractConfigObject relativized(Path var1);

    @Override
    public abstract AbstractConfigValue get(Object var1);

    @Override
    protected abstract void render(StringBuilder var1, int var2, ConfigRenderOptions var3);

    private static UnsupportedOperationException weAreImmutable(String string) {
        return new UnsupportedOperationException("ConfigObject is immutable, you can't call Map." + string);
    }

    @Override
    public void clear() {
        throw AbstractConfigObject.weAreImmutable("clear");
    }

    @Override
    public ConfigValue put(String string, ConfigValue configValue) {
        throw AbstractConfigObject.weAreImmutable("put");
    }

    @Override
    public void putAll(Map<? extends String, ? extends ConfigValue> map) {
        throw AbstractConfigObject.weAreImmutable("putAll");
    }

    @Override
    public ConfigValue remove(Object object) {
        throw AbstractConfigObject.weAreImmutable("remove");
    }
}

