/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.math.genetics;

import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.commons.math.MathRuntimeException;
import oadd.org.apache.commons.math.exception.util.LocalizedFormats;
import oadd.org.apache.commons.math.genetics.Chromosome;
import oadd.org.apache.commons.math.genetics.GeneticAlgorithm;
import oadd.org.apache.commons.math.genetics.MutationPolicy;
import oadd.org.apache.commons.math.genetics.RandomKey;

public class RandomKeyMutation
implements MutationPolicy {
    public Chromosome mutate(Chromosome original) {
        if (!(original instanceof RandomKey)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.RANDOMKEY_MUTATION_WRONG_CLASS, original.getClass().getSimpleName());
        }
        RandomKey originalRk = (RandomKey)original;
        List repr = originalRk.getRepresentation();
        int rInd = GeneticAlgorithm.getRandomGenerator().nextInt(repr.size());
        ArrayList newRepr = new ArrayList(repr);
        newRepr.set(rInd, GeneticAlgorithm.getRandomGenerator().nextDouble());
        return originalRk.newFixedLengthChromosome(newRepr);
    }
}

