/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.config;

import java.util.Set;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.SerializationFeature;
import oadd.com.fasterxml.jackson.databind.module.SimpleModule;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.logical.FormatPluginConfigBase;
import oadd.org.apache.drill.common.logical.StoragePluginConfigBase;
import oadd.org.apache.drill.common.logical.data.LogicalOperatorBase;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;

public class LogicalPlanPersistence {
    private ObjectMapper mapper = new ObjectMapper();

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public LogicalPlanPersistence(DrillConfig conf, ScanResult scanResult) {
        SimpleModule deserModule = new SimpleModule("LogicalExpressionDeserializationModule").addDeserializer(LogicalExpression.class, new LogicalExpression.De(conf)).addDeserializer(SchemaPath.class, new SchemaPath.De());
        this.mapper.registerModule(deserModule);
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.registerSubtypes(LogicalOperatorBase.getSubTypes(scanResult));
        this.registerSubtypes(StoragePluginConfigBase.getSubTypes(scanResult));
        this.registerSubtypes(FormatPluginConfigBase.getSubTypes(scanResult));
    }

    private <T> void registerSubtypes(Set<Class<? extends T>> types) {
        for (Class<T> clazz : types) {
            this.mapper.registerSubtypes(clazz);
        }
    }
}

