/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.util.Iterator;
import java.util.List;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;

public class FunctionCall
extends LogicalExpressionBase
implements Iterable<LogicalExpression> {
    private final String name;
    public final ImmutableList<LogicalExpression> args;
    private final ExpressionPosition pos;

    public FunctionCall(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        super(pos);
        this.name = name;
        if (args == null) {
            args = Lists.newArrayList();
        }
        if (!(args instanceof ImmutableList)) {
            args = ImmutableList.copyOf(args);
        }
        this.args = (ImmutableList)args;
        this.pos = pos;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ExpressionPosition getPosition() {
        return this.pos;
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitFunctionCall(this, value);
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return this.args.iterator();
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        throw new UnsupportedOperationException("No return type as FunctionCall is not a materialized expression");
    }

    public String toString() {
        int maxLen = 10;
        return "FunctionCall [func=" + this.name + ", args=" + (this.args != null ? this.args.subList(0, Math.min(this.args.size(), 10)) : null) + ", pos=" + this.pos + "]";
    }
}

