/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonGenerationException;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import oadd.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import oadd.org.antlr.runtime.ANTLRStringStream;
import oadd.org.antlr.runtime.CommonTokenStream;
import oadd.org.antlr.runtime.RecognitionException;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.ExpressionStringBuilder;
import oadd.org.apache.drill.common.expression.parser.ExprLexer;
import oadd.org.apache.drill.common.expression.parser.ExprParser;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=Se.class)
public interface LogicalExpression
extends Iterable<LogicalExpression> {
    public static final Logger logger = LoggerFactory.getLogger(LogicalExpression.class);

    public TypeProtos.MajorType getMajorType();

    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> var1, V var2) throws E;

    public ExpressionPosition getPosition();

    public int getSelfCost();

    public int getCumulativeCost();

    public static class Se
    extends StdSerializer<LogicalExpression> {
        protected Se() {
            super(LogicalExpression.class);
        }

        @Override
        public void serialize(LogicalExpression value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            StringBuilder sb = new StringBuilder();
            ExpressionStringBuilder esb = new ExpressionStringBuilder();
            value.accept(esb, sb);
            jgen.writeString(sb.toString());
        }
    }

    public static class De
    extends StdDeserializer<LogicalExpression> {
        DrillConfig config;

        public De(DrillConfig config) {
            super(LogicalExpression.class);
            this.config = config;
        }

        @Override
        public LogicalExpression deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String expr = jp.getText();
            if (expr == null || expr.isEmpty()) {
                return null;
            }
            try {
                ExprLexer lexer = new ExprLexer(new ANTLRStringStream(expr));
                CommonTokenStream tokens = new CommonTokenStream(lexer);
                ExprParser parser = new ExprParser(tokens);
                ExprParser.parse_return ret = parser.parse();
                return ret.e;
            }
            catch (RecognitionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

