/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import oadd.org.apache.drill.common.util.CoreDecimalUtility;
import oadd.org.apache.drill.common.util.DrillBaseComputeScalePrecision;

public class DecimalScalePrecisionDivideFunction
extends DrillBaseComputeScalePrecision {
    public DecimalScalePrecisionDivideFunction(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        super(leftPrecision, leftScale, rightPrecision, rightScale);
    }

    @Override
    public void computeScalePrecision(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        this.outputScale = leftScale + rightScale;
        int leftIntegerDigits = leftPrecision - leftScale;
        int maxResultIntegerDigits = leftIntegerDigits + rightScale;
        this.outputPrecision = CoreDecimalUtility.getPrecisionRange(this.outputScale + maxResultIntegerDigits);
        this.outputPrecision = Math.max(this.outputPrecision, Math.max(leftPrecision, rightPrecision));
        this.outputScale = this.outputPrecision - maxResultIntegerDigits >= 0 ? this.outputPrecision - maxResultIntegerDigits : 0;
    }
}

