/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.util.List;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.OpProfileDef;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;

public class FragmentStats {
    private List<OperatorStats> operators = Lists.newArrayList();
    private final long startTime = System.currentTimeMillis();
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final BufferAllocator allocator;

    public FragmentStats(BufferAllocator allocator, CoordinationProtos.DrillbitEndpoint endpoint) {
        this.endpoint = endpoint;
        this.allocator = allocator;
    }

    public void addMetricsToStatus(UserBitShared.MinorFragmentProfile.Builder prfB) {
        prfB.setStartTime(this.startTime);
        prfB.setMaxMemoryUsed(this.allocator.getPeakMemoryAllocation());
        prfB.setEndTime(System.currentTimeMillis());
        prfB.setEndpoint(this.endpoint);
        for (OperatorStats o : this.operators) {
            prfB.addOperatorProfile(o.getProfile());
        }
    }

    public OperatorStats newOperatorStats(OpProfileDef profileDef, BufferAllocator allocator) {
        OperatorStats stats = new OperatorStats(profileDef, allocator);
        if (profileDef.operatorType != -1) {
            this.operators.add(stats);
        }
        return stats;
    }

    public void addOperatorStats(OperatorStats stats) {
        this.operators.add(stats);
    }
}

