/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import oadd.com.google.common.util.concurrent.ListenableFuture;
import oadd.com.google.common.util.concurrent.ListeningExecutorService;
import oadd.com.google.common.util.concurrent.MoreExecutors;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.ops.BaseOperatorContext;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.OpProfileDef;
import oadd.org.apache.drill.exec.ops.OperatorStatReceiver;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.ops.OperatorUtilities;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OperatorContextImpl
extends BaseOperatorContext
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(OperatorContextImpl.class);
    private boolean closed = false;
    private final OperatorStats stats;
    private ListeningExecutorService delegatePool;

    public OperatorContextImpl(PhysicalOperator popConfig, FragmentContext context) throws OutOfMemoryException {
        this(popConfig, context, null);
    }

    public OperatorContextImpl(PhysicalOperator popConfig, FragmentContext context, OperatorStats stats) throws OutOfMemoryException {
        super(context, context.getNewChildAllocator(popConfig.getClass().getSimpleName(), popConfig.getOperatorId(), popConfig.getInitialAllocation(), popConfig.getMaxAllocation()), popConfig);
        if (stats != null) {
            this.stats = stats;
        } else {
            OpProfileDef def = new OpProfileDef(popConfig.getOperatorId(), popConfig.getOperatorType(), OperatorUtilities.getChildCount(popConfig));
            this.stats = context.getStats().newOperatorStats(def, this.allocator);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            logger.debug("Attempted to close Operator context for {}, but context is already closed", (Object)(this.popConfig != null ? this.getName() : null));
            return;
        }
        logger.debug("Closing context for {}", (Object)(this.popConfig != null ? this.getName() : null));
        try {
            super.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public OperatorStats getStats() {
        return this.stats;
    }

    @Override
    public OperatorStatReceiver getStatsWriter() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RESULT> ListenableFuture<RESULT> runCallableAs(final UserGroupInformation proxyUgi, final Callable<RESULT> callable) {
        OperatorContextImpl operatorContextImpl = this;
        synchronized (operatorContextImpl) {
            if (this.delegatePool == null) {
                this.delegatePool = MoreExecutors.listeningDecorator(this.getExecutor());
            }
        }
        return this.delegatePool.submit(new Callable<RESULT>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RESULT call() throws Exception {
                Object result;
                Thread currentThread = Thread.currentThread();
                String originalThreadName = currentThread.getName();
                currentThread.setName(proxyUgi.getUserName() + ":task-delegate-thread");
                try {
                    result = proxyUgi.doAs(new PrivilegedExceptionAction<RESULT>(){

                        @Override
                        public RESULT run() throws Exception {
                            return callable.call();
                        }
                    });
                }
                finally {
                    currentThread.setName(originalThreadName);
                }
                return result;
            }
        });
    }
}

