/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.record.AbstractRecordBatch;
import oadd.org.apache.drill.exec.record.RecordBatch;

public abstract class AbstractBinaryRecordBatch<T extends PhysicalOperator>
extends AbstractRecordBatch<T> {
    protected final RecordBatch left;
    protected final RecordBatch right;
    protected RecordBatch.IterOutcome leftUpstream = RecordBatch.IterOutcome.NONE;
    protected RecordBatch.IterOutcome rightUpstream = RecordBatch.IterOutcome.NONE;

    protected AbstractBinaryRecordBatch(T popConfig, FragmentContext context, RecordBatch left, RecordBatch right) throws OutOfMemoryException {
        super(popConfig, context, true, context.newOperatorContext((PhysicalOperator)popConfig));
        this.left = left;
        this.right = right;
    }

    protected AbstractBinaryRecordBatch(T popConfig, FragmentContext context, boolean buildSchema, RecordBatch left, RecordBatch right) throws OutOfMemoryException {
        super(popConfig, context, buildSchema);
        this.left = left;
        this.right = right;
    }

    protected boolean prefetchFirstBatchFromBothSides() {
        this.leftUpstream = this.next(0, this.left);
        this.rightUpstream = this.next(1, this.right);
        if (this.leftUpstream == RecordBatch.IterOutcome.STOP || this.rightUpstream == RecordBatch.IterOutcome.STOP) {
            this.state = AbstractRecordBatch.BatchState.STOP;
            return false;
        }
        if (this.leftUpstream == RecordBatch.IterOutcome.OUT_OF_MEMORY || this.rightUpstream == RecordBatch.IterOutcome.OUT_OF_MEMORY) {
            this.state = AbstractRecordBatch.BatchState.OUT_OF_MEMORY;
            return false;
        }
        if (this.leftUpstream == RecordBatch.IterOutcome.NONE && this.rightUpstream == RecordBatch.IterOutcome.NONE) {
            this.state = AbstractRecordBatch.BatchState.DONE;
            return false;
        }
        return true;
    }
}

