/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.StackTrace;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.exception.SchemaChangeException;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.SchemaBuilder;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.record.WritableBatch;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;
import oadd.org.apache.drill.exec.record.selection.SelectionVector4;
import oadd.org.apache.drill.exec.vector.AllocationHelper;
import oadd.org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordBatchLoader
implements VectorAccessible,
Iterable<VectorWrapper<?>> {
    private static final Logger logger = LoggerFactory.getLogger(RecordBatchLoader.class);
    private final BufferAllocator allocator;
    private VectorContainer container = new VectorContainer();
    private int valueCount;
    private BatchSchema schema;

    public RecordBatchLoader(BufferAllocator allocator) {
        this.allocator = Preconditions.checkNotNull(allocator);
    }

    public boolean load(UserBitShared.RecordBatchDef def, DrillBuf buf) throws SchemaChangeException {
        if (logger.isTraceEnabled()) {
            logger.trace("Loading record batch with def {} and data {}", (Object)def, (Object)buf);
            logger.trace("Load, ThreadID: {}\n{}", (Object)Thread.currentThread().getId(), (Object)new StackTrace());
        }
        this.container.zeroVectors();
        this.valueCount = def.getRecordCount();
        boolean schemaChanged = this.schema == null;
        CaseInsensitiveMap oldFields = CaseInsensitiveMap.newHashMap();
        for (VectorWrapper<?> wrapper : this.container) {
            Object vector = wrapper.getValueVector();
            oldFields.put(vector.getField().getName(), vector);
        }
        VectorContainer newVectors = new VectorContainer();
        try {
            List<UserBitShared.SerializedField> fields = def.getFieldList();
            int bufOffset = 0;
            for (UserBitShared.SerializedField field : fields) {
                MaterializedField fieldDef = MaterializedField.create(field);
                ValueVector vector = (ValueVector)oldFields.remove(fieldDef.getName());
                if (vector == null) {
                    schemaChanged = true;
                    vector = TypeHelper.getNewVector(fieldDef, this.allocator);
                } else if (!vector.getField().getType().equals(fieldDef.getType())) {
                    vector.clear();
                    schemaChanged = true;
                    vector = TypeHelper.getNewVector(fieldDef, this.allocator);
                } else if (vector.getField().getType().getMinorType() == TypeProtos.MinorType.MAP && !this.isSameSchema(vector.getField().getChildren(), field.getChildList())) {
                    schemaChanged = true;
                    vector.clear();
                    vector = TypeHelper.getNewVector(fieldDef, this.allocator);
                }
                if (field.getValueCount() == 0) {
                    AllocationHelper.allocate(vector, 0, 0, 0);
                } else {
                    vector.load(field, buf.slice(bufOffset, field.getBufferLength()));
                }
                bufOffset += field.getBufferLength();
                newVectors.add(vector);
            }
            SchemaBuilder builder = BatchSchema.newBuilder();
            for (VectorWrapper<?> v : newVectors) {
                builder.addField(v.getField());
            }
            builder.setSelectionVectorMode(BatchSchema.SelectionVectorMode.NONE);
            this.schema = builder.build();
            newVectors.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            this.container = newVectors;
        }
        catch (Throwable cause) {
            for (VectorWrapper<?> wrapper : newVectors) {
                wrapper.getValueVector().clear();
            }
            throw cause;
        }
        finally {
            if (!oldFields.isEmpty()) {
                schemaChanged = true;
                for (ValueVector vector : oldFields.values()) {
                    vector.clear();
                }
            }
        }
        return schemaChanged;
    }

    private boolean isSameSchema(Collection<MaterializedField> currentChildren, List<UserBitShared.SerializedField> newChildren) {
        if (currentChildren.size() != newChildren.size()) {
            return false;
        }
        CaseInsensitiveMap childMap = CaseInsensitiveMap.newHashMap();
        for (MaterializedField currentChild : currentChildren) {
            childMap.put(currentChild.getName(), currentChild);
        }
        for (UserBitShared.SerializedField newChild : newChildren) {
            MaterializedField currentChild = (MaterializedField)childMap.get(newChild.getNamePart().getName());
            if (currentChild == null) {
                return false;
            }
            if (currentChild.getType().equals(newChild.getMajorType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public int getRecordCount() {
        return this.valueCount;
    }

    public VectorContainer getContainer() {
        return this.container;
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    public WritableBatch getWritableBatch() {
        boolean isSV2 = this.schema.getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE;
        return WritableBatch.getBatchNoHVWrap(this.valueCount, this.container, isSV2);
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    public void resetRecordCount() {
        this.valueCount = 0;
    }

    public void clear() {
        this.container.clear();
        this.resetRecordCount();
    }
}

