/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.commons.collections.IteratorUtils;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.config.LogicalPlanPersistence;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.exec.ExecConstants;
import oadd.org.apache.drill.exec.compile.ClassCompilerSelector;
import oadd.org.apache.drill.exec.compile.ClassTransformer;
import oadd.org.apache.drill.exec.planner.physical.PlannerSettings;
import oadd.org.apache.drill.exec.server.options.BaseOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionDefinition;
import oadd.org.apache.drill.exec.server.options.OptionList;
import oadd.org.apache.drill.exec.server.options.OptionMetaData;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.server.options.PersistedOptionValue;
import oadd.org.apache.drill.exec.store.sys.PersistentStore;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreConfig;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreProvider;
import oadd.org.apache.drill.exec.store.sys.store.provider.InMemoryStoreProvider;
import oadd.org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOptionManager
extends BaseOptionManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SystemOptionManager.class);
    private final PersistentStoreConfig<PersistedOptionValue> config;
    private final PersistentStoreProvider provider;
    private PersistentStore<PersistedOptionValue> options;
    private CaseInsensitiveMap<OptionDefinition> definitions;
    private CaseInsensitiveMap<OptionValue> defaults;

    public static CaseInsensitiveMap<OptionDefinition> createDefaultOptionDefinitions() {
        OptionDefinition[] definitions = new OptionDefinition[]{new OptionDefinition(PlannerSettings.CONSTANT_FOLDING), new OptionDefinition(PlannerSettings.EXCHANGE), new OptionDefinition(PlannerSettings.HASHAGG), new OptionDefinition(PlannerSettings.STREAMAGG), new OptionDefinition(PlannerSettings.HASHJOIN), new OptionDefinition(PlannerSettings.MERGEJOIN), new OptionDefinition(PlannerSettings.NESTEDLOOPJOIN), new OptionDefinition(PlannerSettings.MULTIPHASE), new OptionDefinition(PlannerSettings.BROADCAST), new OptionDefinition(PlannerSettings.BROADCAST_THRESHOLD), new OptionDefinition(PlannerSettings.BROADCAST_FACTOR), new OptionDefinition(PlannerSettings.NESTEDLOOPJOIN_FACTOR), new OptionDefinition(PlannerSettings.NLJOIN_FOR_SCALAR), new OptionDefinition(PlannerSettings.JOIN_ROW_COUNT_ESTIMATE_FACTOR), new OptionDefinition(PlannerSettings.MUX_EXCHANGE), new OptionDefinition(PlannerSettings.DEMUX_EXCHANGE), new OptionDefinition(PlannerSettings.PRODUCER_CONSUMER), new OptionDefinition(PlannerSettings.PRODUCER_CONSUMER_QUEUE_SIZE), new OptionDefinition(PlannerSettings.HASH_SINGLE_KEY), new OptionDefinition(PlannerSettings.IDENTIFIER_MAX_LENGTH), new OptionDefinition(PlannerSettings.HASH_JOIN_SWAP), new OptionDefinition(PlannerSettings.HASH_JOIN_SWAP_MARGIN_FACTOR), new OptionDefinition(PlannerSettings.PARTITION_SENDER_THREADS_FACTOR), new OptionDefinition(PlannerSettings.PARTITION_SENDER_MAX_THREADS), new OptionDefinition(PlannerSettings.PARTITION_SENDER_SET_THREADS), new OptionDefinition(PlannerSettings.ENABLE_DECIMAL_DATA_TYPE), new OptionDefinition(PlannerSettings.HEP_OPT), new OptionDefinition(PlannerSettings.PLANNER_MEMORY_LIMIT), new OptionDefinition(PlannerSettings.HEP_PARTITION_PRUNING), new OptionDefinition(PlannerSettings.FILTER_MIN_SELECTIVITY_ESTIMATE_FACTOR), new OptionDefinition(PlannerSettings.FILTER_MAX_SELECTIVITY_ESTIMATE_FACTOR), new OptionDefinition(PlannerSettings.TYPE_INFERENCE), new OptionDefinition(PlannerSettings.IN_SUBQUERY_THRESHOLD), new OptionDefinition(PlannerSettings.UNIONALL_DISTRIBUTE), new OptionDefinition(PlannerSettings.PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING), new OptionDefinition(PlannerSettings.PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD), new OptionDefinition(PlannerSettings.QUOTING_IDENTIFIERS), new OptionDefinition(PlannerSettings.JOIN_OPTIMIZATION), new OptionDefinition(PlannerSettings.FORCE_2PHASE_AGGR), new OptionDefinition(ExecConstants.HASHAGG_NUM_PARTITIONS_VALIDATOR), new OptionDefinition(ExecConstants.HASHAGG_MAX_MEMORY_VALIDATOR), new OptionDefinition(ExecConstants.HASHAGG_MIN_BATCHES_PER_PARTITION_VALIDATOR), new OptionDefinition(ExecConstants.HASHAGG_USE_MEMORY_PREDICTION_VALIDATOR), new OptionDefinition(ExecConstants.HASHAGG_FALLBACK_ENABLED_VALIDATOR), new OptionDefinition(ExecConstants.CAST_TO_NULLABLE_NUMERIC_OPTION), new OptionDefinition(ExecConstants.OUTPUT_FORMAT_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_BLOCK_SIZE_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_WRITER_USE_SINGLE_FS_BLOCK_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_PAGE_SIZE_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_DICT_PAGE_SIZE_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_WRITER_COMPRESSION_TYPE_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_WRITER_ENABLE_DICTIONARY_ENCODING_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_VECTOR_FILL_THRESHOLD_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_VECTOR_FILL_CHECK_THRESHOLD_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_RECORD_READER_IMPLEMENTATION_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_PAGEREADER_ASYNC_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_PAGEREADER_QUEUE_SIZE_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_PAGEREADER_ENFORCETOTALSIZE_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_COLUMNREADER_ASYNC_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_PAGEREADER_USE_BUFFERED_READ_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_PAGEREADER_BUFFER_SIZE_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_PAGEREADER_USE_FADVISE_VALIDATOR), new OptionDefinition(ExecConstants.PARQUET_READER_INT96_AS_TIMESTAMP_VALIDATOR), new OptionDefinition(ExecConstants.JSON_READER_ALL_TEXT_MODE_VALIDATOR), new OptionDefinition(ExecConstants.ENABLE_UNION_TYPE), new OptionDefinition(ExecConstants.TEXT_ESTIMATED_ROW_SIZE), new OptionDefinition(ExecConstants.JSON_EXTENDED_TYPES), new OptionDefinition(ExecConstants.JSON_WRITER_UGLIFY), new OptionDefinition(ExecConstants.JSON_WRITER_SKIPNULLFIELDS), new OptionDefinition(ExecConstants.JSON_READ_NUMBERS_AS_DOUBLE_VALIDATOR), new OptionDefinition(ExecConstants.JSON_SKIP_MALFORMED_RECORDS_VALIDATOR), new OptionDefinition(ExecConstants.JSON_READER_PRINT_INVALID_RECORDS_LINE_NOS_FLAG_VALIDATOR), new OptionDefinition(ExecConstants.FILESYSTEM_PARTITION_COLUMN_LABEL_VALIDATOR), new OptionDefinition(ExecConstants.MONGO_READER_ALL_TEXT_MODE_VALIDATOR), new OptionDefinition(ExecConstants.MONGO_READER_READ_NUMBERS_AS_DOUBLE_VALIDATOR), new OptionDefinition(ExecConstants.MONGO_BSON_RECORD_READER_VALIDATOR), new OptionDefinition(ExecConstants.KAFKA_READER_ALL_TEXT_MODE_VALIDATOR), new OptionDefinition(ExecConstants.KAFKA_RECORD_READER_VALIDATOR), new OptionDefinition(ExecConstants.KAFKA_POLL_TIMEOUT_VALIDATOR), new OptionDefinition(ExecConstants.KAFKA_READER_READ_NUMBERS_AS_DOUBLE_VALIDATOR), new OptionDefinition(ExecConstants.HIVE_OPTIMIZE_SCAN_WITH_NATIVE_READERS_VALIDATOR), new OptionDefinition(ExecConstants.SLICE_TARGET_OPTION), new OptionDefinition(ExecConstants.AFFINITY_FACTOR), new OptionDefinition(ExecConstants.MAX_WIDTH_GLOBAL), new OptionDefinition(ExecConstants.MAX_WIDTH_PER_NODE), new OptionDefinition(ExecConstants.ENABLE_QUEUE), new OptionDefinition(ExecConstants.LARGE_QUEUE_SIZE), new OptionDefinition(ExecConstants.QUEUE_THRESHOLD_SIZE), new OptionDefinition(ExecConstants.QUEUE_TIMEOUT), new OptionDefinition(ExecConstants.SMALL_QUEUE_SIZE), new OptionDefinition(ExecConstants.QUEUE_MEMORY_RESERVE, new OptionMetaData(OptionValue.AccessibleScopes.SYSTEM, true, false)), new OptionDefinition(ExecConstants.QUEUE_MEMORY_RATIO, new OptionMetaData(OptionValue.AccessibleScopes.SYSTEM, true, false)), new OptionDefinition(ExecConstants.MIN_HASH_TABLE_SIZE), new OptionDefinition(ExecConstants.MAX_HASH_TABLE_SIZE), new OptionDefinition(ExecConstants.EARLY_LIMIT0_OPT), new OptionDefinition(ExecConstants.ENABLE_MEMORY_ESTIMATION), new OptionDefinition(ExecConstants.MAX_QUERY_MEMORY_PER_NODE), new OptionDefinition(ExecConstants.PERCENT_MEMORY_PER_QUERY), new OptionDefinition(ExecConstants.MIN_MEMORY_PER_BUFFERED_OP), new OptionDefinition(ExecConstants.NON_BLOCKING_OPERATORS_MEMORY), new OptionDefinition(ExecConstants.HASH_JOIN_TABLE_FACTOR), new OptionDefinition(ExecConstants.HASH_AGG_TABLE_FACTOR), new OptionDefinition(ExecConstants.AVERAGE_FIELD_WIDTH), new OptionDefinition(ExecConstants.NEW_VIEW_DEFAULT_PERMS_VALIDATOR), new OptionDefinition(ExecConstants.CTAS_PARTITIONING_HASH_DISTRIBUTE_VALIDATOR), new OptionDefinition(ExecConstants.ADMIN_USERS_VALIDATOR, new OptionMetaData(OptionValue.AccessibleScopes.SYSTEM, true, false)), new OptionDefinition(ExecConstants.ADMIN_USER_GROUPS_VALIDATOR, new OptionMetaData(OptionValue.AccessibleScopes.SYSTEM, true, false)), new OptionDefinition(ExecConstants.IMPERSONATION_POLICY_VALIDATOR, new OptionMetaData(OptionValue.AccessibleScopes.SYSTEM, true, false)), new OptionDefinition(ClassCompilerSelector.JAVA_COMPILER_VALIDATOR), new OptionDefinition(ClassCompilerSelector.JAVA_COMPILER_JANINO_MAXSIZE), new OptionDefinition(ClassCompilerSelector.JAVA_COMPILER_DEBUG), new OptionDefinition(ExecConstants.ENABLE_VERBOSE_ERRORS), new OptionDefinition(ExecConstants.ENABLE_WINDOW_FUNCTIONS_VALIDATOR), new OptionDefinition(ClassTransformer.SCALAR_REPLACEMENT_VALIDATOR), new OptionDefinition(ExecConstants.ENABLE_NEW_TEXT_READER), new OptionDefinition(ExecConstants.ENABLE_BULK_LOAD_TABLE_LIST), new OptionDefinition(ExecConstants.BULK_LOAD_TABLE_LIST_BULK_SIZE), new OptionDefinition(ExecConstants.WEB_LOGS_MAX_LINES_VALIDATOR), new OptionDefinition(ExecConstants.IMPLICIT_FILENAME_COLUMN_LABEL_VALIDATOR), new OptionDefinition(ExecConstants.IMPLICIT_SUFFIX_COLUMN_LABEL_VALIDATOR), new OptionDefinition(ExecConstants.IMPLICIT_FQN_COLUMN_LABEL_VALIDATOR), new OptionDefinition(ExecConstants.IMPLICIT_FILEPATH_COLUMN_LABEL_VALIDATOR), new OptionDefinition(ExecConstants.CODE_GEN_EXP_IN_METHOD_SIZE_VALIDATOR), new OptionDefinition(ExecConstants.CREATE_PREPARE_STATEMENT_TIMEOUT_MILLIS_VALIDATOR), new OptionDefinition(ExecConstants.DYNAMIC_UDF_SUPPORT_ENABLED_VALIDATOR, new OptionMetaData(OptionValue.AccessibleScopes.SYSTEM, true, false)), new OptionDefinition(ExecConstants.EXTERNAL_SORT_DISABLE_MANAGED_OPTION), new OptionDefinition(ExecConstants.ENABLE_QUERY_PROFILE_VALIDATOR), new OptionDefinition(ExecConstants.QUERY_PROFILE_DEBUG_VALIDATOR), new OptionDefinition(ExecConstants.USE_DYNAMIC_UDFS), new OptionDefinition(ExecConstants.QUERY_TRANSIENT_STATE_UPDATE), new OptionDefinition(ExecConstants.PERSISTENT_TABLE_UMASK_VALIDATOR), new OptionDefinition(ExecConstants.CPU_LOAD_AVERAGE), new OptionDefinition(ExecConstants.ENABLE_VECTOR_VALIDATOR), new OptionDefinition(ExecConstants.ENABLE_ITERATOR_VALIDATOR)};
        CaseInsensitiveMap<OptionDefinition> map = CaseInsensitiveMap.newHashMap();
        for (OptionDefinition definition : definitions) {
            map.put(definition.getValidator().getOptionName(), definition);
        }
        if (AssertionUtil.isAssertionsEnabled()) {
            map.put("drill.exec.testing.controls", new OptionDefinition(ExecConstants.DRILLBIT_CONTROLS_VALIDATOR));
        }
        return map;
    }

    public SystemOptionManager(LogicalPlanPersistence lpPersistence, PersistentStoreProvider provider, DrillConfig bootConfig) {
        this(lpPersistence, provider, bootConfig, SystemOptionManager.createDefaultOptionDefinitions());
    }

    public SystemOptionManager(LogicalPlanPersistence lpPersistence, PersistentStoreProvider provider, DrillConfig bootConfig, CaseInsensitiveMap<OptionDefinition> definitions) {
        this.provider = provider;
        this.config = PersistentStoreConfig.newJacksonBuilder((ObjectMapper)lpPersistence.getMapper(), PersistedOptionValue.class).name("sys.options").build();
        this.definitions = definitions;
        this.defaults = SystemOptionManager.populateDefaultValues(definitions, bootConfig);
    }

    @VisibleForTesting
    public SystemOptionManager(DrillConfig bootConfig) {
        this.provider = new InMemoryStoreProvider(100);
        this.config = null;
        this.definitions = SystemOptionManager.createDefaultOptionDefinitions();
        this.defaults = SystemOptionManager.populateDefaultValues(this.definitions, bootConfig);
    }

    public SystemOptionManager init() throws Exception {
        this.options = this.provider.getOrCreateStore(this.config);
        for (Map.Entry option : Lists.newArrayList(this.options.getAll())) {
            String name = (String)option.getKey();
            OptionDefinition definition = this.definitions.get(name);
            if (definition == null) {
                this.options.delete(name);
                logger.warn("Deleting deprecated option `{}`", (Object)name);
                continue;
            }
            OptionValidator validator = definition.getValidator();
            String canonicalName = validator.getOptionName().toLowerCase();
            if (name.equals(canonicalName)) continue;
            logger.warn("Changing option name to lower case `{}`", (Object)name);
            PersistedOptionValue value = (PersistedOptionValue)option.getValue();
            this.options.delete(name);
            this.options.put(canonicalName, (Object)value);
        }
        return this;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        CaseInsensitiveMap buildList = CaseInsensitiveMap.newHashMap();
        for (Map.Entry<String, OptionValue> entry : this.defaults.entrySet()) {
            buildList.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, OptionValue> entry : Lists.newArrayList(this.options.getAll())) {
            String name = entry.getKey();
            OptionDefinition optionDefinition = this.getOptionDefinition(name);
            PersistedOptionValue persistedOptionValue = (PersistedOptionValue)((Object)entry.getValue());
            OptionValue optionValue = persistedOptionValue.toOptionValue(optionDefinition, OptionValue.OptionScope.SYSTEM);
            buildList.put(name, optionValue);
        }
        return buildList.values().iterator();
    }

    @Override
    public OptionValue getOption(String name) {
        PersistedOptionValue persistedValue = (PersistedOptionValue)this.options.get(name.toLowerCase());
        if (persistedValue != null) {
            OptionDefinition optionDefinition = this.getOptionDefinition(name);
            return persistedValue.toOptionValue(optionDefinition, OptionValue.OptionScope.SYSTEM);
        }
        return this.defaults.get(name);
    }

    @Override
    public OptionValue getDefault(String optionName) {
        OptionValue value = this.defaults.get(optionName);
        if (value == null) {
            throw UserException.systemError(null).addContext("Undefined default value for option: " + optionName).build(logger);
        }
        return value;
    }

    @Override
    protected void setLocalOptionHelper(OptionValue value) {
        String name = value.name.toLowerCase();
        OptionDefinition definition = this.getOptionDefinition(name);
        OptionValidator validator = definition.getValidator();
        validator.validate(value, definition.getMetaData(), this);
        if (this.options.get(name) == null && value.equals(this.getDefault(name))) {
            return;
        }
        this.options.put(name, (Object)value.toPersisted());
    }

    @Override
    protected OptionValue.OptionScope getScope() {
        return OptionValue.OptionScope.SYSTEM;
    }

    @Override
    public void deleteLocalOption(String name) {
        this.getOptionDefinition(name);
        this.options.delete(name.toLowerCase());
    }

    @Override
    public void deleteAllLocalOptions() {
        HashSet<String> names = Sets.newHashSet();
        for (Map.Entry entry : Lists.newArrayList(this.options.getAll())) {
            names.add((String)entry.getKey());
        }
        for (String name : names) {
            this.options.delete(name);
        }
    }

    public static CaseInsensitiveMap<OptionValue> populateDefaultValues(Map<String, OptionDefinition> definitions, DrillConfig bootConfig) {
        HashMap<String, OptionValue> defaults = new HashMap<String, OptionValue>();
        for (Map.Entry<String, OptionDefinition> entry : definitions.entrySet()) {
            OptionValue optionValue;
            OptionDefinition definition = entry.getValue();
            OptionMetaData metaData = definition.getMetaData();
            OptionValue.AccessibleScopes type = metaData.getAccessibleScopes();
            OptionValidator validator = definition.getValidator();
            String name = validator.getOptionName();
            String configName = validator.getConfigProperty();
            OptionValue.Kind kind = validator.getKind();
            switch (kind) {
                case BOOLEAN: {
                    optionValue = OptionValue.create(type, name, bootConfig.getBoolean(configName), OptionValue.OptionScope.BOOT);
                    break;
                }
                case LONG: {
                    optionValue = OptionValue.create(type, name, bootConfig.getLong(configName), OptionValue.OptionScope.BOOT);
                    break;
                }
                case STRING: {
                    optionValue = OptionValue.create(type, name, bootConfig.getString(configName), OptionValue.OptionScope.BOOT);
                    break;
                }
                case DOUBLE: {
                    optionValue = OptionValue.create(type, name, bootConfig.getDouble(configName), OptionValue.OptionScope.BOOT);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            defaults.put(name, optionValue);
        }
        return CaseInsensitiveMap.newImmutableMap(defaults);
    }

    @Override
    public OptionDefinition getOptionDefinition(String name) {
        OptionDefinition definition = this.definitions.get(name);
        if (definition == null) {
            throw UserException.validationError().message(String.format("The option '%s' does not exist.", name.toLowerCase()), new Object[0]).build(logger);
        }
        return definition;
    }

    @Override
    public OptionList getOptionList() {
        return (OptionList)IteratorUtils.toList(this.iterator());
    }

    @Override
    public void close() throws Exception {
        if (this.options != null) {
            this.options.close();
        }
    }
}

