/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.File;
import java.util.HashMap;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.common.logical.StoragePluginConfig;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.dfs.FileSystemConfig;
import oadd.org.apache.drill.exec.store.dfs.FileSystemPlugin;
import oadd.org.apache.drill.exec.store.dfs.WorkspaceConfig;
import oadd.org.apache.drill.exec.store.easy.sequencefile.SequenceFileFormatConfig;
import oadd.org.apache.drill.exec.store.easy.text.TextFormatPlugin;

public class StoragePluginTestUtils {
    public static final String CP_PLUGIN_NAME = "cp";
    public static final String DFS_PLUGIN_NAME = "dfs";
    public static final String TMP_SCHEMA = "tmp";
    public static final String DEFAULT_SCHEMA = "default";
    public static final String ROOT_SCHEMA = "root";
    public static final String DFS_TMP_SCHEMA = "dfs.tmp";
    public static final String DFS_DEFAULT_SCHEMA = "dfs.default";
    public static final String DFS_ROOT_SCHEMA = "dfs.root";
    public static final String UNIT_TEST_PROP_PREFIX = "drillJDBCUnitTests";
    public static final String UNIT_TEST_DFS_TMP_PROP = "drillJDBCUnitTests.dfs.tmp";
    public static final String UNIT_TEST_DFS_DEFAULT_PROP = "drillJDBCUnitTests.dfs.default";
    public static final String UNIT_TEST_DFS_ROOT_PROP = "drillJDBCUnitTests.dfs.root";

    public static void updateSchemaLocation(String pluginName, StoragePluginRegistry pluginRegistry, File tmpDirPath, String ... schemas) throws ExecutionSetupException {
        FileSystemPlugin plugin = (FileSystemPlugin)pluginRegistry.getPlugin(pluginName);
        FileSystemConfig pluginConfig = (FileSystemConfig)plugin.getConfig();
        HashMap<String, WorkspaceConfig> workspaces = Maps.newHashMap();
        if (schemas.length == 0) {
            schemas = new String[]{TMP_SCHEMA};
        }
        for (String schema : schemas) {
            WorkspaceConfig workspaceConfig = (WorkspaceConfig)pluginConfig.workspaces.get(schema);
            String inputFormat = workspaceConfig == null ? null : workspaceConfig.getDefaultInputFormat();
            WorkspaceConfig newWorkspaceConfig = new WorkspaceConfig(tmpDirPath.getAbsolutePath(), true, inputFormat, false);
            workspaces.put(schema, newWorkspaceConfig);
        }
        pluginConfig.workspaces.putAll(workspaces);
        pluginRegistry.createOrUpdate(pluginName, (StoragePluginConfig)pluginConfig, true);
    }

    public static void configureFormatPlugins(StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        StoragePluginTestUtils.configureFormatPlugins(pluginRegistry, CP_PLUGIN_NAME);
        StoragePluginTestUtils.configureFormatPlugins(pluginRegistry, DFS_PLUGIN_NAME);
    }

    public static void configureFormatPlugins(StoragePluginRegistry pluginRegistry, String storagePlugin) throws ExecutionSetupException {
        FileSystemPlugin fileSystemPlugin = (FileSystemPlugin)pluginRegistry.getPlugin(storagePlugin);
        FileSystemConfig fileSystemConfig = (FileSystemConfig)fileSystemPlugin.getConfig();
        TextFormatPlugin.TextFormatConfig textConfig = new TextFormatPlugin.TextFormatConfig();
        textConfig.extensions = ImmutableList.of("txt");
        textConfig.fieldDelimiter = '\u0000';
        fileSystemConfig.formats.put("txt", textConfig);
        TextFormatPlugin.TextFormatConfig ssvConfig = new TextFormatPlugin.TextFormatConfig();
        ssvConfig.extensions = ImmutableList.of("ssv");
        ssvConfig.fieldDelimiter = (char)32;
        fileSystemConfig.formats.put("ssv", ssvConfig);
        TextFormatPlugin.TextFormatConfig psvConfig = new TextFormatPlugin.TextFormatConfig();
        psvConfig.extensions = ImmutableList.of("tbl");
        psvConfig.fieldDelimiter = (char)124;
        fileSystemConfig.formats.put("psv", psvConfig);
        SequenceFileFormatConfig seqConfig = new SequenceFileFormatConfig();
        seqConfig.extensions = ImmutableList.of("seq");
        fileSystemConfig.formats.put("sequencefile", seqConfig);
        TextFormatPlugin.TextFormatConfig csvhtestConfig = new TextFormatPlugin.TextFormatConfig();
        csvhtestConfig.extensions = ImmutableList.of("csvh-test");
        csvhtestConfig.fieldDelimiter = (char)44;
        csvhtestConfig.extractHeader = true;
        csvhtestConfig.skipFirstLine = true;
        fileSystemConfig.formats.put("csvh-test", csvhtestConfig);
        pluginRegistry.createOrUpdate(storagePlugin, (StoragePluginConfig)fileSystemConfig, true);
    }
}

