/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.util.Collection;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Predicate;
import oadd.com.google.common.collect.Iterables;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.expr.fn.impl.DateUtility;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;

public class Utilities {
    public static final SchemaPath STAR_COLUMN = SchemaPath.getSimplePath("*");
    public static final String COL_NULL_ERROR = "Columns cannot be null. Use star column to select all fields.";

    public static String getFileNameForQueryFragment(FragmentContext context, String location, String tag) {
        ExecProtos.FragmentHandle handle = context.getHandle();
        String qid = QueryIdHelper.getQueryId(handle.getQueryId());
        int majorFragmentId = handle.getMajorFragmentId();
        int minorFragmentId = handle.getMinorFragmentId();
        String fileName = String.format("%s//%s_%s_%s_%s", location, qid, majorFragmentId, minorFragmentId, tag);
        return fileName;
    }

    public static BitControl.QueryContextInformation createQueryContextInfo(String defaultSchemaName, String sessionId) {
        long queryStartTime = System.currentTimeMillis();
        int timeZone = DateUtility.getIndex((String)System.getProperty("user.timezone"));
        return BitControl.QueryContextInformation.newBuilder().setDefaultSchemaName(defaultSchemaName).setQueryStartTime(queryStartTime).setTimeZone(timeZone).setSessionId(sessionId).build();
    }

    public static String getDrillVersion() {
        String v = Utilities.class.getPackage().getImplementationVersion();
        return v;
    }

    public static boolean isStarQuery(Collection<SchemaPath> projected) {
        return Iterables.tryFind((Iterable)Preconditions.checkNotNull(projected, COL_NULL_ERROR), new Predicate<SchemaPath>(){

            @Override
            public boolean apply(SchemaPath path) {
                return Preconditions.checkNotNull(path).equals(STAR_COLUMN);
            }
        }).isPresent();
    }
}

