/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedUInt2Holder;
import oadd.org.apache.drill.exec.expr.holders.UInt2Holder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.UInt2Vector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedUInt2ReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedUInt2Vector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private UInt2Vector values;
    private final FieldReader reader = new RepeatedUInt2ReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedUInt2Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create(Types.required(field.getType().getMinorType())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public UInt2Vector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedUInt2Vector)to);
    }

    public AddOrGetResult<UInt2Vector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<UInt2Vector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedUInt2Vector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedUInt2Vector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedUInt2Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedUInt2Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedUInt2Vector)from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super(RepeatedUInt2Vector.this);
        }

        public void add(int index, int value) {
            int nextOffset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt2Vector.this.values.getMutator().set(nextOffset, value);
            RepeatedUInt2Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, char srcValue) {
            int nextOffset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt2Vector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedUInt2Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, char srcValue) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt2Vector.this.values.getMutator().setArrayItem(nextOffset, srcValue);
            RepeatedUInt2Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedUInt2Holder h) {
            UInt2Holder ih = new UInt2Holder();
            UInt2Vector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedUInt2Vector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedUInt2Vector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, UInt2Holder holder) {
            int nextOffset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt2Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedUInt2Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, UInt2Holder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt2Vector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedUInt2Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableUInt2Holder holder) {
            int nextOffset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt2Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedUInt2Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, NullableUInt2Holder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt2Vector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedUInt2Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int fillOffset = RepeatedUInt2Vector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedUInt2Vector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, UInt2Holder holder) {
            int nextOffset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt2Vector.this.values.getMutator().set(nextOffset, holder);
            RepeatedUInt2Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedUInt2Holder holder) {
            UInt2Vector.Accessor accessor = holder.vector.getAccessor();
            UInt2Holder innerHolder = new UInt2Holder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedUInt2Vector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedUInt2Vector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super(RepeatedUInt2Vector.this);
        }

        @Override
        public List<Character> getObject(int index) {
            JsonStringArrayList<Character> vals = new JsonStringArrayList<Character>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedUInt2Vector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            UInt2Vector.Accessor valuesAccessor = RepeatedUInt2Vector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Character getSingleObject(int index, int arrayIndex) {
            int start = RepeatedUInt2Vector.this.offsets.getAccessor().get(index);
            return RepeatedUInt2Vector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public char get(int index, int positionIndex) {
            return RepeatedUInt2Vector.this.values.getAccessor().get(RepeatedUInt2Vector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedUInt2Holder holder) {
            holder.start = RepeatedUInt2Vector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedUInt2Vector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedUInt2Vector.this.values;
        }

        public void get(int index, int positionIndex, UInt2Holder holder) {
            int offset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedUInt2Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableUInt2Holder holder) {
            int offset = RepeatedUInt2Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedUInt2Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedUInt2Vector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedUInt2Vector(field, allocator);
        }

        public TransferImpl(RepeatedUInt2Vector to) {
            this.to = to;
        }

        @Override
        public RepeatedUInt2Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedUInt2Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedUInt2Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedUInt2Vector.this);
        }
    }
}

