/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Set;
import oadd.com.google.common.base.Charsets;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import oadd.org.apache.drill.exec.expr.holders.VarBinaryHolder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.NullableVarBinaryVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VariableWidthVector;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.VarBinaryReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VarBinaryVector
extends BaseDataValueVector
implements VariableWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(VarBinaryVector.class);
    private static final int DEFAULT_RECORD_BYTE_COUNT = 8;
    private static final int INITIAL_BYTE_COUNT = Math.min(32768, MAX_BUFFER_SIZE);
    private static final int MIN_BYTE_COUNT = 4096;
    public static final String OFFSETS_VECTOR_NAME = "$offsets$";
    private final MaterializedField offsetsField = MaterializedField.create("$offsets$", Types.required(TypeProtos.MinorType.UINT4));
    private final UInt4Vector offsetVector = new UInt4Vector(this.offsetsField, this.allocator);
    private final FieldReader reader = new VarBinaryReaderImpl(this);
    private final Accessor accessor;
    private final Mutator mutator;
    private final UInt4Vector.Accessor oAccessor;
    private int allocationSizeInBytes = INITIAL_BYTE_COUNT;
    private int allocationMonitor = 0;

    public VarBinaryVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.oAccessor = this.offsetVector.getAccessor();
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSize() {
        if (this.getAccessor().getValueCount() == 0) {
            return 0;
        }
        return this.offsetVector.getBufferSize() + this.data.writerIndex();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int idx = this.offsetVector.getAccessor().get(valueCount);
        return this.offsetVector.getBufferSizeFor(valueCount + 1) + idx;
    }

    @Override
    public int getValueCapacity() {
        return Math.max(this.offsetVector.getValueCapacity() - 1, 0);
    }

    @Override
    public int getByteCapacity() {
        return this.data.capacity();
    }

    @Override
    public int getCurrentSizeInBytes() {
        return this.offsetVector.getAccessor().get(this.getAccessor().getValueCount());
    }

    public int getVarByteLength() {
        int valueCount = this.getAccessor().getValueCount();
        if (valueCount == 0) {
            return 0;
        }
        return this.offsetVector.getAccessor().get(valueCount);
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().addChild(this.offsetVector.getMetadata()).setValueCount(this.getAccessor().getValueCount()).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        UserBitShared.SerializedField offsetField = metadata.getChild(0);
        this.offsetVector.load(offsetField, buffer);
        int capacity = buffer.capacity();
        int offsetsLength = offsetField.getBufferLength();
        this.data = buffer.slice(offsetsLength, capacity - offsetsLength);
        this.data.retain();
    }

    @Override
    public void clear() {
        super.clear();
        this.offsetVector.clear();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsetVector.getBuffers(false), super.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    public long getOffsetAddr() {
        return this.offsetVector.getBuffer().memoryAddress();
    }

    public UInt4Vector getOffsetVector() {
        return this.offsetVector;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((VarBinaryVector)to);
    }

    public void transferTo(VarBinaryVector target) {
        target.clear();
        this.offsetVector.transferTo(target.offsetVector);
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, VarBinaryVector target) {
        UInt4Vector.Accessor offsetVectorAccessor = this.offsetVector.getAccessor();
        int startPoint = offsetVectorAccessor.get(startIndex);
        int sliceLength = offsetVectorAccessor.get(startIndex + length) - startPoint;
        target.clear();
        target.offsetVector.allocateNew(length + 1);
        offsetVectorAccessor = this.offsetVector.getAccessor();
        UInt4Vector.Mutator targetOffsetVectorMutator = target.offsetVector.getMutator();
        for (int i = 0; i < length + 1; ++i) {
            targetOffsetVectorMutator.set(i, offsetVectorAccessor.get(startIndex + i) - startPoint);
        }
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.getMutator().setValueCount(length);
    }

    protected void copyFrom(int fromIndex, int thisIndex, VarBinaryVector from) {
        UInt4Vector.Accessor fromOffsetVectorAccessor = from.offsetVector.getAccessor();
        int start = fromOffsetVectorAccessor.get(fromIndex);
        int end = fromOffsetVectorAccessor.get(fromIndex + 1);
        int len = end - start;
        int outputStart = this.offsetVector.data.getInt(thisIndex * 4);
        from.data.getBytes(start, this.data, outputStart, len);
        this.offsetVector.data.setInt((thisIndex + 1) * 4, outputStart + len);
    }

    public boolean copyFromSafe(int fromIndex, int thisIndex, VarBinaryVector from) {
        UInt4Vector.Accessor fromOffsetVectorAccessor = from.offsetVector.getAccessor();
        int start = fromOffsetVectorAccessor.get(fromIndex);
        int end = fromOffsetVectorAccessor.get(fromIndex + 1);
        int len = end - start;
        int outputStart = this.offsetVector.data.getInt(thisIndex * 4);
        while (this.data.capacity() < outputStart + len) {
            this.reAlloc();
        }
        this.offsetVector.getMutator().setSafe(thisIndex + 1, outputStart + len);
        from.data.getBytes(start, this.data, outputStart, len);
        return true;
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (VarBinaryVector)from);
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.offsetVector.collectLedgers(ledgers);
        super.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.offsetVector.getAccessor().get(valueCount) + this.offsetVector.getPayloadByteCount(valueCount);
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 4L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
        this.offsetVector.setInitialCapacity(valueCount + 1);
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(4096L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize *= 2L;
            this.allocationMonitor = 0;
        }
        if (curAllocationSize > Integer.MAX_VALUE) {
            return false;
        }
        this.clear();
        try {
            int requestedSize = (int)curAllocationSize;
            this.data = this.allocator.buffer(requestedSize);
            this.allocationSizeInBytes = requestedSize;
            this.offsetVector.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            return false;
        }
        this.data.readerIndex(0);
        this.offsetVector.zeroVector();
        return true;
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount) {
        this.clear();
        assert (totalBytes >= 0);
        try {
            this.data = this.allocator.buffer(totalBytes);
            this.offsetVector.allocateNew(valueCount + 1);
        }
        catch (RuntimeException e) {
            this.clear();
            throw e;
        }
        this.data.readerIndex(0);
        this.allocationSizeInBytes = totalBytes;
        this.offsetVector.zeroVector();
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = INITIAL_BYTE_COUNT;
        this.allocationMonitor = 0;
        this.data.readerIndex(0);
        this.offsetVector.zeroVector();
        super.reset();
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.trace("Reallocating VarChar, new size {}", (Object)newAllocationSize);
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        this.data.release();
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void exchange(ValueVector other) {
        super.exchange(other);
        VarBinaryVector target = (VarBinaryVector)other;
        this.offsetVector.exchange(target.offsetVector);
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        NullableVarBinaryVector dest = (NullableVarBinaryVector)nullableVector;
        dest.getMutator().fromNotNullable(this);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements VariableWidthVector.VariableWidthMutator {
        protected void set(int index, byte[] bytes) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + bytes.length);
            VarBinaryVector.this.data.setBytes(currentOffset, bytes, 0, bytes.length);
        }

        public void setSafe(int index, byte[] bytes) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + bytes.length);
            try {
                VarBinaryVector.this.data.setBytes(currentOffset, bytes, 0, bytes.length);
            }
            catch (IndexOutOfBoundsException e) {
                while (VarBinaryVector.this.data.capacity() < currentOffset + bytes.length) {
                    VarBinaryVector.this.reAlloc();
                }
                VarBinaryVector.this.data.setBytes(currentOffset, bytes, 0, bytes.length);
            }
        }

        public void setScalar(int index, byte[] bytes) throws VectorOverflowException {
            this.setScalar(index, bytes, 0, bytes.length);
        }

        protected void set(int index, byte[] bytes, int start, int length) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            VarBinaryVector.this.data.setBytes(currentOffset, bytes, start, length);
        }

        public void setSafe(int index, ByteBuffer bytes, int start, int length) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + length);
            try {
                VarBinaryVector.this.data.setBytes(currentOffset, bytes, start, length);
            }
            catch (IndexOutOfBoundsException e) {
                while (VarBinaryVector.this.data.capacity() < currentOffset + length) {
                    VarBinaryVector.this.reAlloc();
                }
                VarBinaryVector.this.data.setBytes(currentOffset, bytes, start, length);
            }
        }

        public void setScalar(int index, DrillBuf bytes, int start, int length) throws VectorOverflowException {
            assert (index >= 0);
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            int newSize = currentOffset + length;
            if (newSize > ValueVector.MAX_BUFFER_SIZE) {
                throw new VectorOverflowException();
            }
            while (!VarBinaryVector.this.data.setBytesBounded(currentOffset, bytes, start, length)) {
                VarBinaryVector.this.reAlloc();
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, newSize);
        }

        public void setSafe(int index, byte[] bytes, int start, int length) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + length);
            try {
                VarBinaryVector.this.data.setBytes(currentOffset, bytes, start, length);
            }
            catch (IndexOutOfBoundsException e) {
                while (VarBinaryVector.this.data.capacity() < currentOffset + length) {
                    VarBinaryVector.this.reAlloc();
                }
                VarBinaryVector.this.data.setBytes(currentOffset, bytes, start, length);
            }
        }

        public void setScalar(int index, byte[] bytes, int start, int length) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            this.setArrayItem(index, bytes, start, length);
        }

        public void setArrayItem(int index, byte[] bytes, int start, int length) throws VectorOverflowException {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            int newSize = currentOffset + length;
            if (newSize > ValueVector.MAX_BUFFER_SIZE) {
                throw new VectorOverflowException();
            }
            while (!VarBinaryVector.this.data.setBytesBounded(currentOffset, bytes, start, length)) {
                VarBinaryVector.this.reAlloc();
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, newSize);
        }

        @Override
        public void setValueLengthSafe(int index, int length) {
            int offset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            while (VarBinaryVector.this.data.capacity() < offset + length) {
                VarBinaryVector.this.reAlloc();
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, VarBinaryVector.this.offsetVector.getAccessor().get(index) + length);
        }

        public void setSafe(int index, int start, int end, DrillBuf buffer) {
            int len = end - start;
            int outputStart = ((VarBinaryVector)VarBinaryVector.this).offsetVector.data.getInt(index * 4);
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, outputStart + len);
            try {
                buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            catch (IndexOutOfBoundsException e) {
                while (VarBinaryVector.this.data.capacity() < outputStart + len) {
                    VarBinaryVector.this.reAlloc();
                }
                buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
        }

        public void setScalar(int index, int start, int end, DrillBuf buffer) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            this.setArrayItem(index, start, end, buffer);
        }

        public void setArrayItem(int index, int start, int end, DrillBuf buffer) throws VectorOverflowException {
            int len = end - start;
            int outputStart = ((VarBinaryVector)VarBinaryVector.this).offsetVector.data.getInt(index * 4);
            int newSize = outputStart + len;
            if (newSize > ValueVector.MAX_BUFFER_SIZE) {
                throw new VectorOverflowException();
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, newSize);
            try {
                buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            catch (IndexOutOfBoundsException e) {
                while (VarBinaryVector.this.data.capacity() < newSize) {
                    VarBinaryVector.this.reAlloc();
                }
                buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
        }

        public void setSafe(int index, NullableVarBinaryHolder holder) {
            assert (holder.isSet == 1);
            int start = holder.start;
            int end = holder.end;
            int len = end - start;
            int outputStart = ((VarBinaryVector)VarBinaryVector.this).offsetVector.data.getInt(index * 4);
            try {
                holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            catch (IndexOutOfBoundsException e) {
                while (VarBinaryVector.this.data.capacity() < outputStart + len) {
                    VarBinaryVector.this.reAlloc();
                }
                holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, outputStart + len);
        }

        public void setScalar(int index, NullableVarBinaryHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            this.setArrayItem(index, holder);
        }

        public void setArrayItem(int index, NullableVarBinaryHolder holder) throws VectorOverflowException {
            assert (holder.isSet == 1);
            int start = holder.start;
            int end = holder.end;
            int len = end - start;
            int outputStart = ((VarBinaryVector)VarBinaryVector.this).offsetVector.data.getInt(index * 4);
            int newSize = outputStart + len;
            if (newSize > ValueVector.MAX_BUFFER_SIZE) {
                throw new VectorOverflowException();
            }
            try {
                holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            catch (IndexOutOfBoundsException e) {
                while (VarBinaryVector.this.data.capacity() < newSize) {
                    VarBinaryVector.this.reAlloc();
                }
                holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, newSize);
        }

        public void setSafe(int index, VarBinaryHolder holder) {
            int start = holder.start;
            int end = holder.end;
            int len = end - start;
            int outputStart = ((VarBinaryVector)VarBinaryVector.this).offsetVector.data.getInt(index * 4);
            try {
                holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            catch (IndexOutOfBoundsException e) {
                while (VarBinaryVector.this.data.capacity() < outputStart + len) {
                    VarBinaryVector.this.reAlloc();
                }
                holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, outputStart + len);
        }

        public void setScalar(int index, VarBinaryHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            this.setArrayItem(index, holder);
        }

        public void setArrayItem(int index, VarBinaryHolder holder) throws VectorOverflowException {
            int start = holder.start;
            int end = holder.end;
            int len = end - start;
            int outputStart = ((VarBinaryVector)VarBinaryVector.this).offsetVector.data.getInt(index * 4);
            int newSize = outputStart + len;
            if (newSize > ValueVector.MAX_BUFFER_SIZE) {
                throw new VectorOverflowException();
            }
            try {
                holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            catch (IndexOutOfBoundsException e) {
                while (VarBinaryVector.this.data.capacity() < newSize) {
                    VarBinaryVector.this.reAlloc();
                }
                holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, newSize);
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            if (index > 65536) {
                throw new VectorOverflowException();
            }
            int fillOffset = VarBinaryVector.this.offsetVector.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = VarBinaryVector.this.offsetVector.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void set(int index, int start, int length, DrillBuf buffer) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            DrillBuf bb = buffer.slice(start, length);
            VarBinaryVector.this.data.setBytes(currentOffset, bb);
        }

        protected void set(int index, NullableVarBinaryHolder holder) {
            int length = holder.end - holder.start;
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            VarBinaryVector.this.data.setBytes(currentOffset, holder.buffer, holder.start, length);
        }

        protected void set(int index, VarBinaryHolder holder) {
            int length = holder.end - holder.start;
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            VarBinaryVector.this.data.setBytes(currentOffset, holder.buffer, holder.start, length);
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentByteCapacity = VarBinaryVector.this.getByteCapacity();
            int idx = VarBinaryVector.this.offsetVector.getAccessor().get(valueCount);
            VarBinaryVector.this.data.writerIndex(idx);
            if (valueCount > 0 && currentByteCapacity > idx * 2) {
                VarBinaryVector.this.incrementAllocationMonitor();
            } else if (VarBinaryVector.this.allocationMonitor > 0) {
                VarBinaryVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(VarBinaryVector.this.data, idx);
            VarBinaryVector.this.offsetVector.getMutator().setValueCount(valueCount == 0 ? 0 : valueCount + 1);
        }

        @Override
        public void generateTestData(int size) {
            boolean even = true;
            Charset charset = Charsets.UTF_8;
            byte[] evenValue = new String("aaaaa").getBytes(charset);
            byte[] oddValue = new String("bbbbbbbbbb").getBytes(charset);
            for (int i = 0; i < size; ++i) {
                this.set(i, even ? evenValue : oddValue);
                even = !even;
            }
            this.setValueCount(size);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor
    implements VariableWidthVector.VariableWidthAccessor {
        final UInt4Vector.Accessor oAccessor;

        public Accessor() {
            this.oAccessor = VarBinaryVector.this.offsetVector.getAccessor();
        }

        public long getStartEnd(int index) {
            return this.oAccessor.getTwoAsLong(index);
        }

        public byte[] get(int index) {
            assert (index >= 0);
            int startIdx = this.oAccessor.get(index);
            int length = this.oAccessor.get(index + 1) - startIdx;
            assert (length >= 0);
            byte[] dst = new byte[length];
            VarBinaryVector.this.data.getBytes(startIdx, dst, 0, length);
            return dst;
        }

        @Override
        public int getValueLength(int index) {
            UInt4Vector.Accessor offsetVectorAccessor = VarBinaryVector.this.offsetVector.getAccessor();
            return offsetVectorAccessor.get(index + 1) - offsetVectorAccessor.get(index);
        }

        public void get(int index, VarBinaryHolder holder) {
            holder.start = this.oAccessor.get(index);
            holder.end = this.oAccessor.get(index + 1);
            holder.buffer = VarBinaryVector.this.data;
        }

        public void get(int index, NullableVarBinaryHolder holder) {
            holder.isSet = 1;
            holder.start = this.oAccessor.get(index);
            holder.end = this.oAccessor.get(index + 1);
            holder.buffer = VarBinaryVector.this.data;
        }

        public byte[] getObject(int index) {
            return this.get(index);
        }

        @Override
        public int getValueCount() {
            return Math.max(VarBinaryVector.this.offsetVector.getAccessor().getValueCount() - 1, 0);
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public UInt4Vector getOffsetVector() {
            return VarBinaryVector.this.offsetVector;
        }
    }

    private class TransferImpl
    implements TransferPair {
        VarBinaryVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new VarBinaryVector(field, allocator);
        }

        public TransferImpl(VarBinaryVector to) {
            this.to = to;
        }

        @Override
        public VarBinaryVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            VarBinaryVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            VarBinaryVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, VarBinaryVector.this);
        }
    }
}

