/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.NullableVarCharVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class NullableVarCharWriterImpl
extends AbstractFieldWriter {
    private final NullableVarCharVector.Mutator mutator;
    final NullableVarCharVector vector;

    public NullableVarCharWriterImpl(NullableVarCharVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(VarCharHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableVarCharHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarChar(int start, int end, DrillBuf buffer) {
        this.mutator.setSafe(this.idx(), 1, start, end, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.mutator.setNull(this.idx());
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

