/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.io.IOException;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.BlockLocation;
import oadd.org.apache.hadoop.fs.FileStatus;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LocatedFileStatus
extends FileStatus {
    private BlockLocation[] locations;

    public LocatedFileStatus(FileStatus stat, BlockLocation[] locations) throws IOException {
        this(stat.getLen(), stat.isDirectory(), stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getAccessTime(), stat.getPermission(), stat.getOwner(), stat.getGroup(), null, stat.getPath(), locations);
        if (this.isSymlink()) {
            this.setSymlink(stat.getSymlink());
        }
    }

    public LocatedFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path symlink, Path path, BlockLocation[] locations) {
        super(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, symlink, path);
        this.locations = locations;
    }

    public BlockLocation[] getBlockLocations() {
        return this.locations;
    }

    @Override
    public int compareTo(Object o) {
        return super.compareTo(o);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

