/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.proto.ReplyHeader;
import oadd.org.apache.zookeeper.server.Request;
import oadd.org.apache.zookeeper.server.RequestProcessor;
import oadd.org.apache.zookeeper.server.ZooKeeperServer;
import oadd.org.apache.zookeeper.server.ZooTrace;
import oadd.org.apache.zookeeper.server.quorum.Leader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRequestProcessor
extends Thread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyRequestProcessor.class);
    private LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    private boolean finished = false;
    private RequestProcessor nextProcessor;
    private ZooKeeperServer zks;

    public ReadOnlyRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ReadOnlyRequestProcessor:" + zks.getServerId());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
    }

    public void run() {
        try {
            block9: while (!this.finished) {
                Request request = this.queuedRequests.take();
                long traceMask = 2L;
                if (request.type == 11) {
                    traceMask = 8L;
                }
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, traceMask, 'R', request, "");
                }
                if (Request.requestOfDeath != request) {
                    switch (request.type) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 9: 
                        case 13: 
                        case 14: {
                            ReplyHeader hdr = new ReplyHeader(request.cxid, this.zks.getZKDatabase().getDataTreeLastProcessedZxid(), KeeperException.Code.NOTREADONLY.intValue());
                            try {
                                request.cnxn.sendResponse(hdr, null, null);
                            }
                            catch (IOException e) {
                                LOG.error("IO exception while sending response", e);
                            }
                            continue block9;
                        }
                    }
                    if (this.nextProcessor == null) continue;
                    this.nextProcessor.processRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            LOG.error("Unexpected interruption", e);
        }
        catch (RequestProcessor.RequestProcessorException e) {
            if (e.getCause() instanceof Leader.XidRolloverException) {
                LOG.info(e.getCause().getMessage());
            }
            LOG.error("Unexpected exception", e);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception", e);
        }
        LOG.info("ReadOnlyRequestProcessor exited loop!");
    }

    public void processRequest(Request request) {
        if (!this.finished) {
            this.queuedRequests.add(request);
        }
    }

    public void shutdown() {
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

