/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.math.optimization.general;

import oadd.org.apache.commons.math.ConvergenceException;
import oadd.org.apache.commons.math.FunctionEvaluationException;
import oadd.org.apache.commons.math.analysis.UnivariateRealFunction;
import oadd.org.apache.commons.math.analysis.solvers.BrentSolver;
import oadd.org.apache.commons.math.analysis.solvers.UnivariateRealSolver;
import oadd.org.apache.commons.math.exception.util.LocalizedFormats;
import oadd.org.apache.commons.math.optimization.GoalType;
import oadd.org.apache.commons.math.optimization.OptimizationException;
import oadd.org.apache.commons.math.optimization.RealPointValuePair;
import oadd.org.apache.commons.math.optimization.general.AbstractScalarDifferentiableOptimizer;
import oadd.org.apache.commons.math.optimization.general.ConjugateGradientFormula;
import oadd.org.apache.commons.math.optimization.general.Preconditioner;
import oadd.org.apache.commons.math.util.FastMath;

public class NonLinearConjugateGradientOptimizer
extends AbstractScalarDifferentiableOptimizer {
    private final ConjugateGradientFormula updateFormula;
    private Preconditioner preconditioner;
    private UnivariateRealSolver solver;
    private double initialStep;

    public NonLinearConjugateGradientOptimizer(ConjugateGradientFormula updateFormula) {
        this.updateFormula = updateFormula;
        this.preconditioner = null;
        this.solver = null;
        this.initialStep = 1.0;
    }

    public void setPreconditioner(Preconditioner preconditioner) {
        this.preconditioner = preconditioner;
    }

    public void setLineSearchSolver(UnivariateRealSolver lineSearchSolver) {
        this.solver = lineSearchSolver;
    }

    public void setInitialStep(double initialStep) {
        this.initialStep = initialStep <= 0.0 ? 1.0 : initialStep;
    }

    /*
     * Unable to fully structure code
     */
    protected RealPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        try {
            if (this.preconditioner == null) {
                this.preconditioner = new IdentityPreconditioner();
            }
            if (this.solver == null) {
                this.solver = new BrentSolver();
            }
            n = this.point.length;
            r = this.computeObjectiveGradient(this.point);
            if (this.goal == GoalType.MINIMIZE) {
                for (i = 0; i < n; ++i) {
                    r[i] = -r[i];
                }
            }
            steepestDescent = this.preconditioner.precondition(this.point, r);
            searchDirection = (double[])steepestDescent.clone();
            delta = 0.0;
            for (i = 0; i < n; ++i) {
                delta += r[i] * searchDirection[i];
            }
            current = null;
            block4: while (true) {
                objective = this.computeObjectiveValue(this.point);
                previous = current;
                current = new RealPointValuePair(this.point, objective);
                if (previous != null && this.checker.converged(this.getIterations(), previous, current)) {
                    return current;
                }
                this.incrementIterationsCounter();
                dTd = 0.0;
                for (double di : searchDirection) {
                    dTd += di * di;
                }
                lsf = new LineSearchFunction(searchDirection);
                step = this.solver.solve(lsf, 0.0, this.findUpperBound(lsf, 0.0, this.initialStep));
                for (i = 0; i < this.point.length; ++i) {
                    v0 = i;
                    this.point[v0] = this.point[v0] + step * searchDirection[i];
                }
                r = this.computeObjectiveGradient(this.point);
                if (this.goal == GoalType.MINIMIZE) {
                    for (i = 0; i < n; ++i) {
                        r[i] = -r[i];
                    }
                }
                deltaOld = delta;
                newSteepestDescent = this.preconditioner.precondition(this.point, r);
                delta = 0.0;
                for (i = 0; i < n; ++i) {
                    delta += r[i] * newSteepestDescent[i];
                }
                if (this.updateFormula == ConjugateGradientFormula.FLETCHER_REEVES) {
                    beta = delta / deltaOld;
                } else {
                    deltaMid = 0.0;
                    for (i = 0; i < r.length; ++i) {
                        deltaMid += r[i] * steepestDescent[i];
                    }
                    beta = (delta - deltaMid) / deltaOld;
                }
                steepestDescent = newSteepestDescent;
                if (this.getIterations() % n == 0 || beta < 0.0) {
                    searchDirection = (double[])steepestDescent.clone();
                    continue;
                }
                i = 0;
                while (true) {
                    if (i < n) ** break;
                    continue block4;
                    searchDirection[i] = steepestDescent[i] + beta * searchDirection[i];
                    ++i;
                }
                break;
            }
        }
        catch (ConvergenceException ce) {
            throw new OptimizationException(ce);
        }
    }

    private double findUpperBound(UnivariateRealFunction f, double a, double h) throws FunctionEvaluationException, OptimizationException {
        double yA;
        double yB = yA = f.value(a);
        for (double step = h; step < Double.MAX_VALUE; step *= FastMath.max(2.0, yA / yB)) {
            double b = a + step;
            yB = f.value(b);
            if (!(yA * yB <= 0.0)) continue;
            return b;
        }
        throw new OptimizationException(LocalizedFormats.UNABLE_TO_BRACKET_OPTIMUM_IN_LINE_SEARCH, new Object[0]);
    }

    private class LineSearchFunction
    implements UnivariateRealFunction {
        private final double[] searchDirection;

        public LineSearchFunction(double[] searchDirection) {
            this.searchDirection = searchDirection;
        }

        public double value(double x) throws FunctionEvaluationException {
            double[] shiftedPoint = (double[])NonLinearConjugateGradientOptimizer.this.point.clone();
            for (int i = 0; i < shiftedPoint.length; ++i) {
                int n = i;
                shiftedPoint[n] = shiftedPoint[n] + x * this.searchDirection[i];
            }
            double[] gradient = NonLinearConjugateGradientOptimizer.this.computeObjectiveGradient(shiftedPoint);
            double dotProduct = 0.0;
            for (int i = 0; i < gradient.length; ++i) {
                dotProduct += gradient[i] * this.searchDirection[i];
            }
            return dotProduct;
        }
    }

    private static class IdentityPreconditioner
    implements Preconditioner {
        private IdentityPreconditioner() {
        }

        public double[] precondition(double[] variables, double[] r) {
            return (double[])r.clone();
        }
    }
}

