/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oadd.com.google.common.collect.ArrayListMultimap;
import oadd.com.google.common.collect.ListMultimap;
import oadd.com.google.common.collect.Multimaps;
import oadd.org.apache.drill.common.graph.AdjacencyListBuilder;
import oadd.org.apache.drill.common.graph.Edge;
import oadd.org.apache.drill.common.graph.GraphAlgos;
import oadd.org.apache.drill.common.graph.GraphValue;

class AdjacencyList<V extends GraphValue<V>> {
    private Set<Node> allNodes = new HashSet<Node>();
    private ListMultimap<Node, Edge<Node>> adjacencies = ArrayListMultimap.create();

    AdjacencyList() {
    }

    void addEdge(Node source, Node target, int weight) {
        this.adjacencies.put(source, new Edge<Node>(source, target, weight));
        this.allNodes.add(source);
        this.allNodes.add(target);
    }

    void clearVisited() {
        for (Edge e : this.adjacencies.values()) {
            ((Node)e.from).visited = false;
            ((Node)e.to).visited = false;
        }
    }

    Node getNewNode(V value) {
        return new Node(this, value);
    }

    public List<Edge<Node>> getAdjacent(Node source) {
        return this.adjacencies.get(source);
    }

    public void printEdges() {
        for (Edge e : this.adjacencies.values()) {
            System.out.println(((Node)e.from).index + " -> " + ((Node)e.to).index);
        }
    }

    public AdjacencyList<V> getReversedList() {
        AdjacencyList<V> newlist = new AdjacencyList<V>();
        for (Edge e : this.adjacencies.values()) {
            newlist.addEdge((Node)e.to, (Node)e.from, e.weight);
        }
        return newlist;
    }

    public Set<Node> getNodeSet() {
        return this.adjacencies.keySet();
    }

    Collection<Node> getInternalLeafNodes() {
        LinkedList<Node> nodes = new LinkedList<Node>(this.allNodes);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            List<Edge<Node>> adjList = this.getAdjacent(n);
            if (adjList == null || adjList.isEmpty()) continue;
            i.remove();
        }
        return nodes;
    }

    public Collection<V> getLeafNodes() {
        return this.convert(this.getInternalLeafNodes());
    }

    Collection<Node> getInternalRootNodes() {
        HashSet<Node> nodes = new HashSet<Node>(this.getNodeSet());
        for (Edge e : this.adjacencies.values()) {
            nodes.remove(e.to);
        }
        return nodes;
    }

    public List<V> getRootNodes() {
        return this.convert(this.getInternalRootNodes());
    }

    public Collection<Edge<Node>> getAllEdges() {
        return this.adjacencies.values();
    }

    public void fix(boolean requireDirected) {
        List<List<Node>> cyclicReferences;
        this.adjacencies = Multimaps.unmodifiableListMultimap(this.adjacencies);
        this.allNodes = Collections.unmodifiableSet(this.allNodes);
        if (requireDirected && (cyclicReferences = GraphAlgos.checkDirected(this)).size() > 0) {
            throw new IllegalArgumentException("A logical plan must be a valid DAG.  You have cyclic references in your graph.  " + cyclicReferences);
        }
    }

    List<V> convert(Collection<Node> nodes) {
        ArrayList out = new ArrayList(nodes.size());
        for (Node o : nodes) {
            out.add(o.getNodeValue());
        }
        return out;
    }

    public static <V extends GraphValue<V>> AdjacencyList<V> newInstance(Collection<V> nodes) {
        AdjacencyList<V> list = new AdjacencyList<V>();
        AdjacencyListBuilder<V> builder = new AdjacencyListBuilder<V>(list);
        for (GraphValue v : nodes) {
            v.accept(builder);
        }
        return builder.getAdjacencyList();
    }

    static class Node
    implements Comparable<Node> {
        final V nodeValue;
        boolean visited = false;
        int lowlink = -1;
        int index = -1;
        final /* synthetic */ AdjacencyList this$0;

        public Node(V operator) {
            this.this$0 = this$0;
            if (operator == null) {
                throw new IllegalArgumentException("Operator node was null.");
            }
            this.nodeValue = operator;
        }

        @Override
        public int compareTo(Node argNode) {
            return argNode == this ? 0 : -1;
        }

        public int hashCode() {
            return this.nodeValue.hashCode();
        }

        public V getNodeValue() {
            return this.nodeValue;
        }

        public String toString() {
            return "Node [val=" + this.nodeValue + "]";
        }
    }
}

