/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.dotdrill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.exec.dotdrill.DotDrillFile;
import oadd.org.apache.drill.exec.dotdrill.DotDrillType;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.hadoop.fs.FileStatus;
import oadd.org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DotDrillUtil {
    static final Logger logger = LoggerFactory.getLogger(DotDrillUtil.class);

    private static List<DotDrillFile> getDrillFiles(DrillFileSystem fs, FileStatus[] statuses, DotDrillType ... types) {
        ArrayList<DotDrillFile> files = Lists.newArrayList();
        for (FileStatus s : statuses) {
            DotDrillFile f = DotDrillFile.create(fs, s);
            if (f == null) continue;
            if (types.length == 0) {
                files.add(f);
                continue;
            }
            for (DotDrillType t : types) {
                if (t != f.getType()) continue;
                files.add(f);
            }
        }
        return files;
    }

    public static List<DotDrillFile> getDotDrills(DrillFileSystem fs, Path root, DotDrillType ... types) throws IOException {
        return DotDrillUtil.getDrillFiles(fs, fs.globStatus(new Path(root, "*.drill")), types);
    }

    public static List<DotDrillFile> getDotDrills(DrillFileSystem fs, Path root, String name, DotDrillType ... types) throws IOException {
        if (!name.endsWith(".drill")) {
            name = name + DotDrillType.DOT_DRILL_GLOB;
        }
        return DotDrillUtil.getDrillFiles(fs, fs.globStatus(new Path(root, name)), types);
    }
}

