/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr.stat;

import java.util.List;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.exec.expr.stat.ParquetFilterPredicate;
import oadd.org.apache.drill.exec.expr.stat.RangeExprEvaluator;

public abstract class ParquetBooleanPredicate<C extends Comparable<C>>
extends BooleanOperator
implements ParquetFilterPredicate<C> {
    private ParquetBooleanPredicate(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        super(name, args, pos);
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitBooleanOperator(this, value);
    }

    private static <C extends Comparable<C>> LogicalExpression createAndPredicate(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        return new ParquetBooleanPredicate<C>(name, (List)args, pos){

            @Override
            public boolean canDrop(RangeExprEvaluator<C> evaluator) {
                for (LogicalExpression child : this) {
                    if (!(child instanceof ParquetFilterPredicate) || !((ParquetFilterPredicate)((Object)child)).canDrop(evaluator)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static <C extends Comparable<C>> LogicalExpression createOrPredicate(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        return new ParquetBooleanPredicate<C>(name, (List)args, pos){

            @Override
            public boolean canDrop(RangeExprEvaluator<C> evaluator) {
                for (LogicalExpression child : this) {
                    if (child instanceof ParquetFilterPredicate && ((ParquetFilterPredicate)((Object)child)).canDrop(evaluator)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <C extends Comparable<C>> LogicalExpression createBooleanPredicate(String function, String name, List<LogicalExpression> args, ExpressionPosition pos) {
        switch (function) {
            case "booleanOr": {
                return ParquetBooleanPredicate.createOrPredicate(name, args, pos);
            }
            case "booleanAnd": {
                return ParquetBooleanPredicate.createAndPredicate(name, args, pos);
            }
        }
        logger.warn("Unknown Boolean '{}' predicate.", (Object)function);
        return null;
    }
}

