/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr.stat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.BiPredicate;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.exec.expr.stat.ParquetFilterPredicate;
import oadd.org.apache.drill.exec.expr.stat.ParquetPredicatesHelper;
import oadd.org.apache.drill.exec.expr.stat.RangeExprEvaluator;
import org.apache.parquet.column.statistics.Statistics;

public class ParquetComparisonPredicate<C extends Comparable<C>>
extends LogicalExpressionBase
implements ParquetFilterPredicate<C> {
    private final LogicalExpression left;
    private final LogicalExpression right;
    private final BiPredicate<Statistics<C>, Statistics<C>> predicate;

    private ParquetComparisonPredicate(LogicalExpression left, LogicalExpression right, BiPredicate<Statistics<C>, Statistics<C>> predicate) {
        super(left.getPosition());
        this.left = left;
        this.right = right;
        this.predicate = predicate;
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
        args.add(this.left);
        args.add(this.right);
        return args.iterator();
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitUnknown(this, value);
    }

    @Override
    public boolean canDrop(RangeExprEvaluator<C> evaluator) {
        Statistics leftStat = (Statistics)this.left.accept(evaluator, null);
        if (ParquetPredicatesHelper.isNullOrEmpty(leftStat)) {
            return false;
        }
        Statistics rightStat = (Statistics)this.right.accept(evaluator, null);
        if (ParquetPredicatesHelper.isNullOrEmpty(rightStat)) {
            return false;
        }
        if (ParquetPredicatesHelper.isAllNulls(leftStat, evaluator.getRowCount()) || ParquetPredicatesHelper.isAllNulls(rightStat, evaluator.getRowCount())) {
            return true;
        }
        return leftStat.hasNonNullValue() && rightStat.hasNonNullValue() && this.predicate.test(leftStat, rightStat);
    }

    private static <C extends Comparable<C>> LogicalExpression createEqualPredicate(final LogicalExpression left, final LogicalExpression right) {
        return new ParquetComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparable leftMin = leftStat.genericGetMin();
            Comparable rightMin = rightStat.genericGetMin();
            return leftStat.compareMaxToValue(rightMin) < 0 || rightStat.compareMaxToValue(leftMin) < 0;
        }){

            public String toString() {
                return left + " = " + right;
            }
        };
    }

    private static <C extends Comparable<C>> LogicalExpression createGTPredicate(LogicalExpression left, LogicalExpression right) {
        return new ParquetComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparable rightMin = rightStat.genericGetMin();
            return leftStat.compareMaxToValue(rightMin) <= 0;
        });
    }

    private static <C extends Comparable<C>> LogicalExpression createGEPredicate(LogicalExpression left, LogicalExpression right) {
        return new ParquetComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparable rightMin = rightStat.genericGetMin();
            return leftStat.compareMaxToValue(rightMin) < 0;
        });
    }

    private static <C extends Comparable<C>> LogicalExpression createLTPredicate(LogicalExpression left, LogicalExpression right) {
        return new ParquetComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparable leftMin = leftStat.genericGetMin();
            return rightStat.compareMaxToValue(leftMin) <= 0;
        });
    }

    private static <C extends Comparable<C>> LogicalExpression createLEPredicate(LogicalExpression left, LogicalExpression right) {
        return new ParquetComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparable leftMin = leftStat.genericGetMin();
            return rightStat.compareMaxToValue(leftMin) < 0;
        });
    }

    private static <C extends Comparable<C>> LogicalExpression createNEPredicate(LogicalExpression left, LogicalExpression right) {
        return new ParquetComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparable leftMax = leftStat.genericGetMax();
            Comparable rightMax = rightStat.genericGetMax();
            return leftStat.compareMinToValue(leftMax) == 0 && rightStat.compareMinToValue(rightMax) == 0 && leftStat.compareMaxToValue(rightMax) == 0;
        });
    }

    public static <C extends Comparable<C>> LogicalExpression createComparisonPredicate(String function, LogicalExpression left, LogicalExpression right) {
        switch (function) {
            case "equal": {
                return ParquetComparisonPredicate.createEqualPredicate(left, right);
            }
            case "greater_than": {
                return ParquetComparisonPredicate.createGTPredicate(left, right);
            }
            case "greater_than_or_equal_to": {
                return ParquetComparisonPredicate.createGEPredicate(left, right);
            }
            case "less_than": {
                return ParquetComparisonPredicate.createLTPredicate(left, right);
            }
            case "less_than_or_equal_to": {
                return ParquetComparisonPredicate.createLEPredicate(left, right);
            }
            case "not_equal": {
                return ParquetComparisonPredicate.createNEPredicate(left, right);
            }
        }
        return null;
    }
}

