/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr.stat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedFieldExpr;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.fn.CastFunctions;
import oadd.org.apache.drill.common.expression.fn.FuncHolder;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.DrillSimpleFunc;
import oadd.org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.interpreter.InterpreterEvaluator;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.Float4Holder;
import oadd.org.apache.drill.exec.expr.holders.Float8Holder;
import oadd.org.apache.drill.exec.expr.holders.IntHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.store.parquet.stat.ColumnStatistics;
import oadd.org.apache.drill.exec.vector.ValueHolderHelper;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeExprEvaluator<T extends Comparable<T>>
extends AbstractExprVisitor<Statistics<T>, Void, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(RangeExprEvaluator.class);
    private final Map<SchemaPath, ColumnStatistics<T>> columnStatMap;
    private final long rowCount;
    private static final Map<TypeProtos.MinorType, Set<TypeProtos.MinorType>> CAST_FUNC = new HashMap<TypeProtos.MinorType, Set<TypeProtos.MinorType>>();

    public RangeExprEvaluator(Map<SchemaPath, ColumnStatistics<T>> columnStatMap, long rowCount) {
        this.columnStatMap = columnStatMap;
        this.rowCount = rowCount;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public Statistics<T> visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        return null;
    }

    @Override
    public Statistics<T> visitTypedFieldExpr(TypedFieldExpr typedFieldExpr, Void value) throws RuntimeException {
        ColumnStatistics<T> columnStatistics = this.columnStatMap.get(typedFieldExpr.getPath());
        if (columnStatistics != null) {
            return columnStatistics.getStatistics();
        }
        if (typedFieldExpr.getMajorType().equals(Types.OPTIONAL_INT)) {
            Statistics statistics = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32);
            statistics.setNumNulls(this.rowCount);
            return statistics;
        }
        return null;
    }

    @Override
    public Statistics<T> visitIntConstant(ValueExpressions.IntExpression expr, Void value) throws RuntimeException {
        return this.getStatistics(expr.getInt());
    }

    @Override
    public Statistics<T> visitBooleanConstant(ValueExpressions.BooleanExpression expr, Void value) throws RuntimeException {
        return this.getStatistics(expr.getBoolean());
    }

    @Override
    public Statistics<T> visitLongConstant(ValueExpressions.LongExpression expr, Void value) throws RuntimeException {
        return this.getStatistics(expr.getLong());
    }

    @Override
    public Statistics<T> visitFloatConstant(ValueExpressions.FloatExpression expr, Void value) throws RuntimeException {
        return this.getStatistics(expr.getFloat());
    }

    @Override
    public Statistics<T> visitDoubleConstant(ValueExpressions.DoubleExpression expr, Void value) throws RuntimeException {
        return this.getStatistics(expr.getDouble());
    }

    @Override
    public Statistics<T> visitDateConstant(ValueExpressions.DateExpression expr, Void value) throws RuntimeException {
        long dateInMillis = expr.getDate();
        return this.getStatistics(dateInMillis);
    }

    @Override
    public Statistics<T> visitTimeStampConstant(ValueExpressions.TimeStampExpression tsExpr, Void value) throws RuntimeException {
        long tsInMillis = tsExpr.getTimeStamp();
        return this.getStatistics(tsInMillis);
    }

    @Override
    public Statistics<T> visitTimeConstant(ValueExpressions.TimeExpression timeExpr, Void value) throws RuntimeException {
        int milliSeconds = timeExpr.getTime();
        return this.getStatistics(milliSeconds);
    }

    @Override
    public Statistics<T> visitFunctionHolderExpression(FunctionHolderExpression holderExpr, Void value) throws RuntimeException {
        Statistics stat;
        FuncHolder funcHolder = holderExpr.getHolder();
        if (!(funcHolder instanceof DrillSimpleFuncHolder)) {
            return null;
        }
        String funcName = ((DrillSimpleFuncHolder)funcHolder).getRegisteredNames()[0];
        if (CastFunctions.isCastFunction(funcName) && (stat = (Statistics)((LogicalExpression)holderExpr.args.get(0)).accept(this, null)) != null && !stat.isEmpty()) {
            return this.evalCastFunc(holderExpr, stat);
        }
        return null;
    }

    private Statistics<T> getStatistics(int value) {
        return this.getStatistics(value, value);
    }

    private Statistics<T> getStatistics(int min, int max) {
        Statistics statistics = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32);
        ((IntStatistics)statistics).setMinMax(min, max);
        return statistics;
    }

    private Statistics<T> getStatistics(boolean value) {
        return this.getStatistics(value, value);
    }

    private Statistics<T> getStatistics(boolean min, boolean max) {
        Statistics statistics = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN);
        ((BooleanStatistics)statistics).setMinMax(min, max);
        return statistics;
    }

    private Statistics<T> getStatistics(long value) {
        return this.getStatistics(value, value);
    }

    private Statistics<T> getStatistics(long min, long max) {
        Statistics statistics = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64);
        ((LongStatistics)statistics).setMinMax(min, max);
        return statistics;
    }

    private Statistics<T> getStatistics(double value) {
        return this.getStatistics(value, value);
    }

    private Statistics<T> getStatistics(double min, double max) {
        Statistics statistics = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE);
        ((DoubleStatistics)statistics).setMinMax(min, max);
        return statistics;
    }

    private Statistics<T> getStatistics(float value) {
        return this.getStatistics(value, value);
    }

    private Statistics<T> getStatistics(float min, float max) {
        Statistics statistics = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT);
        ((FloatStatistics)statistics).setMinMax(min, max);
        return statistics;
    }

    private Statistics<T> evalCastFunc(FunctionHolderExpression holderExpr, Statistics input) {
        try {
            ValueHolder maxHolder;
            ValueHolder minHolder;
            DrillSimpleFuncHolder funcHolder = (DrillSimpleFuncHolder)holderExpr.getHolder();
            DrillSimpleFunc interpreter = funcHolder.createInterpreter();
            TypeProtos.MinorType srcType = ((LogicalExpression)holderExpr.args.get(0)).getMajorType().getMinorType();
            TypeProtos.MinorType destType = holderExpr.getMajorType().getMinorType();
            if (srcType.equals(destType)) {
                return input;
            }
            if (!CAST_FUNC.containsKey(srcType) || !CAST_FUNC.get(srcType).contains(destType)) {
                return null;
            }
            switch (srcType) {
                case INT: {
                    minHolder = ValueHolderHelper.getIntHolder(((IntStatistics)input).getMin());
                    maxHolder = ValueHolderHelper.getIntHolder(((IntStatistics)input).getMax());
                    break;
                }
                case BIGINT: {
                    minHolder = ValueHolderHelper.getBigIntHolder(((LongStatistics)input).getMin());
                    maxHolder = ValueHolderHelper.getBigIntHolder(((LongStatistics)input).getMax());
                    break;
                }
                case FLOAT4: {
                    minHolder = ValueHolderHelper.getFloat4Holder(((FloatStatistics)input).getMin());
                    maxHolder = ValueHolderHelper.getFloat4Holder(((FloatStatistics)input).getMax());
                    break;
                }
                case FLOAT8: {
                    minHolder = ValueHolderHelper.getFloat8Holder(((DoubleStatistics)input).getMin());
                    maxHolder = ValueHolderHelper.getFloat8Holder(((DoubleStatistics)input).getMax());
                    break;
                }
                case DATE: {
                    minHolder = ValueHolderHelper.getDateHolder(((LongStatistics)input).getMin());
                    maxHolder = ValueHolderHelper.getDateHolder(((LongStatistics)input).getMax());
                    break;
                }
                default: {
                    return null;
                }
            }
            ValueHolder[] args1 = new ValueHolder[]{minHolder};
            ValueHolder[] args2 = new ValueHolder[]{maxHolder};
            ValueHolder minFuncHolder = InterpreterEvaluator.evaluateFunction((DrillSimpleFunc)interpreter, (ValueHolder[])args1, (String)holderExpr.getName());
            ValueHolder maxFuncHolder = InterpreterEvaluator.evaluateFunction((DrillSimpleFunc)interpreter, (ValueHolder[])args2, (String)holderExpr.getName());
            switch (destType) {
                case INT: {
                    return this.getStatistics(((IntHolder)minFuncHolder).value, ((IntHolder)maxFuncHolder).value);
                }
                case BIGINT: {
                    return this.getStatistics(((BigIntHolder)minFuncHolder).value, ((BigIntHolder)maxFuncHolder).value);
                }
                case FLOAT4: {
                    return this.getStatistics(((Float4Holder)minFuncHolder).value, ((Float4Holder)maxFuncHolder).value);
                }
                case FLOAT8: {
                    return this.getStatistics(((Float8Holder)minFuncHolder).value, ((Float8Holder)maxFuncHolder).value);
                }
                case TIMESTAMP: {
                    return this.getStatistics(((TimeStampHolder)minFuncHolder).value, ((TimeStampHolder)maxFuncHolder).value);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Error in evaluating function of " + holderExpr.getName());
        }
    }

    static {
        CAST_FUNC.put(TypeProtos.MinorType.FLOAT4, new HashSet());
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT4).add(TypeProtos.MinorType.FLOAT8);
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT4).add(TypeProtos.MinorType.INT);
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT4).add(TypeProtos.MinorType.BIGINT);
        CAST_FUNC.put(TypeProtos.MinorType.FLOAT8, new HashSet());
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT8).add(TypeProtos.MinorType.FLOAT4);
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT8).add(TypeProtos.MinorType.INT);
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT8).add(TypeProtos.MinorType.BIGINT);
        CAST_FUNC.put(TypeProtos.MinorType.INT, new HashSet());
        CAST_FUNC.get(TypeProtos.MinorType.INT).add(TypeProtos.MinorType.FLOAT4);
        CAST_FUNC.get(TypeProtos.MinorType.INT).add(TypeProtos.MinorType.FLOAT8);
        CAST_FUNC.get(TypeProtos.MinorType.INT).add(TypeProtos.MinorType.BIGINT);
        CAST_FUNC.put(TypeProtos.MinorType.BIGINT, new HashSet());
        CAST_FUNC.get(TypeProtos.MinorType.BIGINT).add(TypeProtos.MinorType.INT);
        CAST_FUNC.get(TypeProtos.MinorType.BIGINT).add(TypeProtos.MinorType.FLOAT4);
        CAST_FUNC.get(TypeProtos.MinorType.BIGINT).add(TypeProtos.MinorType.FLOAT8);
        CAST_FUNC.put(TypeProtos.MinorType.DATE, new HashSet());
        CAST_FUNC.get(TypeProtos.MinorType.DATE).add(TypeProtos.MinorType.TIMESTAMP);
    }
}

