/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleSchema;
import oadd.org.apache.drill.exec.record.metadata.VariantMetadata;

public abstract class AbstractColumnMetadata
implements ColumnMetadata {
    protected final String name;
    protected final TypeProtos.MinorType type;
    protected final TypeProtos.DataMode mode;
    protected final int precision;
    protected final int scale;
    protected boolean projected = true;
    protected int expectedElementCount = 1;

    public AbstractColumnMetadata(MaterializedField schema) {
        this.name = schema.getName();
        TypeProtos.MajorType majorType = schema.getType();
        this.type = majorType.getMinorType();
        this.mode = majorType.getMode();
        this.precision = majorType.getPrecision();
        this.scale = majorType.getScale();
        if (this.isArray()) {
            this.expectedElementCount = 10;
        }
    }

    public AbstractColumnMetadata(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        this.name = name;
        this.type = type;
        this.mode = mode;
        this.precision = 0;
        this.scale = 0;
        if (this.isArray()) {
            this.expectedElementCount = 10;
        }
    }

    public AbstractColumnMetadata(AbstractColumnMetadata from) {
        this.name = from.name;
        this.type = from.type;
        this.mode = from.mode;
        this.precision = from.precision;
        this.scale = from.scale;
        this.expectedElementCount = from.expectedElementCount;
    }

    protected void bind(TupleSchema parentTuple) {
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TypeProtos.MinorType type() {
        return this.type;
    }

    @Override
    public TypeProtos.MajorType majorType() {
        return TypeProtos.MajorType.newBuilder().setMinorType(this.type()).setMode(this.mode()).build();
    }

    @Override
    public TypeProtos.DataMode mode() {
        return this.mode;
    }

    @Override
    public boolean isNullable() {
        return this.mode() == TypeProtos.DataMode.OPTIONAL;
    }

    @Override
    public boolean isArray() {
        return this.mode() == TypeProtos.DataMode.REPEATED;
    }

    @Override
    public int dimensions() {
        return this.isArray() ? 1 : 0;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isVariant() {
        return false;
    }

    @Override
    public TupleMetadata mapSchema() {
        return null;
    }

    @Override
    public VariantMetadata variantSchema() {
        return null;
    }

    @Override
    public ColumnMetadata childSchema() {
        return null;
    }

    @Override
    public boolean isVariableWidth() {
        TypeProtos.MinorType type = this.type();
        return type == TypeProtos.MinorType.VARCHAR || type == TypeProtos.MinorType.VAR16CHAR || type == TypeProtos.MinorType.VARBINARY;
    }

    @Override
    public boolean isEquivalent(ColumnMetadata other) {
        return this.schema().isEquivalent(other.schema());
    }

    @Override
    public int expectedWidth() {
        return 0;
    }

    @Override
    public void setExpectedWidth(int width) {
    }

    @Override
    public int precision() {
        return 0;
    }

    @Override
    public int scale() {
        return 0;
    }

    @Override
    public void setExpectedElementCount(int childCount) {
        if (this.isArray()) {
            this.expectedElementCount = Math.max(1, childCount);
        }
    }

    @Override
    public int expectedElementCount() {
        return this.expectedElementCount;
    }

    @Override
    public void setProjected(boolean projected) {
        this.projected = projected;
    }

    @Override
    public boolean isProjected() {
        return this.projected;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("[").append(this.getClass().getSimpleName()).append(" ").append(this.schema().toString()).append(", ").append(this.projected ? "" : "not ").append("projected");
        if (this.isArray()) {
            buf.append(", cardinality: ").append(this.expectedElementCount);
        }
        if (this.variantSchema() != null) {
            buf.append(", variant: ").append(this.variantSchema().toString());
        }
        if (this.mapSchema() != null) {
            buf.append(", schema: ").append(this.mapSchema().toString());
        }
        return buf.append("]").toString();
    }

    public abstract AbstractColumnMetadata copy();
}

