/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;

public class PrimitiveColumnMetadata
extends AbstractColumnMetadata {
    protected int expectedWidth;

    public PrimitiveColumnMetadata(MaterializedField schema) {
        super(schema);
        this.expectedWidth = this.estimateWidth(schema.getType());
    }

    public PrimitiveColumnMetadata(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        super(name, type, mode);
        this.expectedWidth = this.estimateWidth(Types.withMode(type, mode));
    }

    private int estimateWidth(TypeProtos.MajorType majorType) {
        if (this.type() == TypeProtos.MinorType.NULL || this.type() == TypeProtos.MinorType.LATE) {
            return 0;
        }
        if (this.isVariableWidth()) {
            int precision = majorType.getPrecision();
            if (precision > 0) {
                return precision;
            }
            return TypeHelper.getSize(majorType) - 4;
        }
        return TypeHelper.getSize(majorType);
    }

    public PrimitiveColumnMetadata(PrimitiveColumnMetadata from) {
        super(from);
        this.expectedWidth = from.expectedWidth;
    }

    @Override
    public AbstractColumnMetadata copy() {
        return new PrimitiveColumnMetadata(this);
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.PRIMITIVE;
    }

    @Override
    public int expectedWidth() {
        return this.expectedWidth;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public void setExpectedWidth(int width) {
        if (this.isVariableWidth()) {
            this.expectedWidth = Math.max(1, width);
        }
    }

    @Override
    public ColumnMetadata cloneEmpty() {
        return new PrimitiveColumnMetadata(this);
    }

    public ColumnMetadata mergeWith(MaterializedField field) {
        PrimitiveColumnMetadata merged = new PrimitiveColumnMetadata(field);
        merged.setExpectedElementCount(this.expectedElementCount);
        merged.setExpectedWidth(Math.max(this.expectedWidth, field.getPrecision()));
        merged.setProjected(this.projected);
        return merged;
    }

    @Override
    public TypeProtos.MajorType majorType() {
        return TypeProtos.MajorType.newBuilder().setMinorType(this.type).setMode(this.mode).setPrecision(this.precision).setScale(this.scale).build();
    }

    @Override
    public MaterializedField schema() {
        return MaterializedField.create(this.name, this.majorType());
    }

    @Override
    public MaterializedField emptySchema() {
        return this.schema();
    }
}

