/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MetadataUtils;

public class RepeatedListColumnMetadata
extends AbstractColumnMetadata {
    public static final int UNKNOWN_DIMENSIONS = -1;
    private AbstractColumnMetadata childSchema;

    public RepeatedListColumnMetadata(MaterializedField field) {
        super(field);
        Preconditions.checkArgument(field.getType().getMinorType() == TypeProtos.MinorType.LIST);
        Preconditions.checkArgument(field.getType().getMode() == TypeProtos.DataMode.REPEATED);
        Preconditions.checkArgument(field.getChildren().size() <= 1);
        if (!field.getChildren().isEmpty()) {
            this.childSchema = MetadataUtils.fromField(field.getChildren().iterator().next());
            Preconditions.checkArgument(this.childSchema.isArray());
        }
    }

    public RepeatedListColumnMetadata(String name, AbstractColumnMetadata childSchema) {
        super(name, TypeProtos.MinorType.LIST, TypeProtos.DataMode.REPEATED);
        if (childSchema != null) {
            Preconditions.checkArgument(childSchema.isArray());
        }
        this.childSchema = childSchema;
    }

    public void childSchema(ColumnMetadata childMetadata) {
        Preconditions.checkState(this.childSchema == null);
        Preconditions.checkArgument(childMetadata.mode() == TypeProtos.DataMode.REPEATED);
        this.childSchema = (AbstractColumnMetadata)childMetadata;
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.MULTI_ARRAY;
    }

    @Override
    public MaterializedField schema() {
        MaterializedField field = this.emptySchema();
        if (this.childSchema != null) {
            field.addChild(this.childSchema.schema());
        }
        return field;
    }

    @Override
    public MaterializedField emptySchema() {
        return MaterializedField.create(this.name(), this.majorType());
    }

    @Override
    public ColumnMetadata cloneEmpty() {
        return new RepeatedListColumnMetadata(this.name, null);
    }

    @Override
    public AbstractColumnMetadata copy() {
        return new RepeatedListColumnMetadata(this.name, this.childSchema);
    }

    @Override
    public ColumnMetadata childSchema() {
        return this.childSchema;
    }

    @Override
    public int dimensions() {
        return this.childSchema == null ? -1 : this.childSchema.dimensions() + 1;
    }
}

