/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.List;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MetadataUtils;
import oadd.org.apache.drill.exec.record.metadata.VariantMetadata;
import oadd.org.apache.drill.exec.record.metadata.VariantSchema;

public class VariantColumnMetadata
extends AbstractColumnMetadata {
    private final VariantSchema variantSchema;

    public VariantColumnMetadata(MaterializedField schema) {
        super(schema);
        this.variantSchema = new VariantSchema();
        this.variantSchema.bind(this);
        List<TypeProtos.MinorType> types = null;
        if (this.type() == TypeProtos.MinorType.UNION) {
            types = schema.getType().getSubTypeList();
        } else {
            TypeProtos.MinorType childType;
            MaterializedField child;
            assert (this.type() == TypeProtos.MinorType.LIST);
            if (schema.getChildren().isEmpty()) {
                child = null;
                childType = TypeProtos.MinorType.LATE;
            } else {
                child = schema.getChildren().iterator().next();
                childType = child.getType().getMinorType();
            }
            switch (childType) {
                case UNION: {
                    types = child.getType().getSubTypeList();
                    break;
                }
                case LATE: {
                    return;
                }
                default: {
                    this.variantSchema.addType(MetadataUtils.fromField(child));
                    return;
                }
            }
        }
        if (types == null) {
            return;
        }
        for (TypeProtos.MinorType type : types) {
            this.variantSchema.addType(type);
        }
    }

    public VariantColumnMetadata(MaterializedField schema, VariantSchema variantSchema) {
        super(schema);
        this.variantSchema = variantSchema;
    }

    public VariantColumnMetadata(String name, TypeProtos.MinorType type, VariantSchema variantSchema) {
        super(name, type, TypeProtos.DataMode.OPTIONAL);
        this.variantSchema = variantSchema == null ? new VariantSchema() : variantSchema;
        this.variantSchema.bind(this);
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.VARIANT;
    }

    @Override
    public boolean isVariant() {
        return true;
    }

    @Override
    public boolean isArray() {
        return this.type() == TypeProtos.MinorType.LIST;
    }

    @Override
    public ColumnMetadata cloneEmpty() {
        return new VariantColumnMetadata(this.name, this.type, this.variantSchema.cloneEmpty());
    }

    @Override
    public AbstractColumnMetadata copy() {
        assert (false);
        return null;
    }

    @Override
    public VariantMetadata variantSchema() {
        return this.variantSchema;
    }

    @Override
    public MaterializedField schema() {
        return MaterializedField.create(this.name, TypeProtos.MajorType.newBuilder().setMinorType(this.type).setMode(TypeProtos.DataMode.OPTIONAL).addAllSubType(this.variantSchema.types()).build());
    }

    @Override
    public MaterializedField emptySchema() {
        return MaterializedField.create(this.name, TypeProtos.MajorType.newBuilder().setMinorType(this.type).setMode(TypeProtos.DataMode.OPTIONAL).build());
    }
}

