/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.MessageLite;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.rpc.BasicClient;
import oadd.org.apache.drill.exec.rpc.BitConnectionConfig;
import oadd.org.apache.drill.exec.rpc.ClientConnection;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import oadd.org.apache.drill.exec.rpc.security.SaslProperties;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitRpcUtility {
    private static final Logger logger = LoggerFactory.getLogger(BitRpcUtility.class);

    public static List<String> validateHandshake(int handshakeRpcVersion, List<String> remoteAuthMechs, int rpcVersion, ClientConnection connection, BitConnectionConfig config, BasicClient client) throws RpcException {
        if (handshakeRpcVersion != rpcVersion) {
            throw new RpcException(String.format("Invalid rpc version.  Expected %d, actual %d.", handshakeRpcVersion, rpcVersion));
        }
        if (remoteAuthMechs.size() != 0) {
            client.setAuthComplete(false);
            return ImmutableList.copyOf(remoteAuthMechs);
        }
        if (config.getAuthMechanismToUse() != null) {
            throw new RpcException(String.format("Remote Drillbit does not require auth, but auth is enabled in local Drillbit configuration. [Details: connection: (%s) and LocalAuthMechanism: (%s). Please check security configuration for bit-to-bit.", connection.getName(), config.getAuthMechanismToUse()));
        }
        return null;
    }

    public static <T extends Internal.EnumLite, CC extends ClientConnection, HS extends MessageLite, HR extends MessageLite> void prepareSaslHandshake(RpcConnectionHandler<CC> connectionHandler, List<String> serverAuthMechanisms, CC connection, BitConnectionConfig config, CoordinationProtos.DrillbitEndpoint endpoint, BasicClient<T, CC, HS, HR> client, T saslRpcType) {
        try {
            Map<String, String> saslProperties = SaslProperties.getSaslProperties(connection.isEncryptionEnabled(), connection.getMaxWrappedSize());
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            AuthenticatorFactory factory = config.getAuthFactory(serverAuthMechanisms);
            client.startSaslHandshake(connectionHandler, config.getSaslClientProperties(endpoint, saslProperties), ugi, factory, saslRpcType);
        }
        catch (IOException e) {
            logger.error("Failed while doing setup for starting sasl handshake for connection", (Object)connection.getName());
            RpcException ex = new RpcException(String.format("Failed to initiate authentication to %s", endpoint.getAddress()), e);
            connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.AUTHENTICATION, ex);
        }
    }

    public static boolean isLocalControlServer(CoordinationProtos.DrillbitEndpoint local, CoordinationProtos.DrillbitEndpoint remote) {
        return local.hasAddress() && local.hasControlPort() && remote.hasAddress() && remote.hasControlPort() && local.getAddress().equals(remote.getAddress()) && local.getControlPort() == remote.getControlPort();
    }

    private BitRpcUtility() {
    }
}

