/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.channel.Channel;
import oadd.io.netty.channel.ChannelFuture;
import oadd.io.netty.util.concurrent.Future;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.common.exceptions.DrillException;
import oadd.org.apache.drill.exec.rpc.BasicClient;
import oadd.org.apache.drill.exec.rpc.ClientConnection;
import oadd.org.apache.drill.exec.rpc.NonTransientRpcException;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionMultiListener<T extends Internal.EnumLite, CC extends ClientConnection, HS extends MessageLite, HR extends MessageLite, BC extends BasicClient<T, CC, HS, HR>> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionMultiListener.class);
    private final RpcConnectionHandler<CC> connectionListener;
    private final HS handshakeValue;
    private final BC parent;
    ConnectionHandler connectionHandler = null;
    private HandshakeSendHandler handshakeSendHandler = null;
    private SSLConnectionHandler sslConnectionHandler = null;

    private ConnectionMultiListener(RpcConnectionHandler<CC> connectionListener, HS handshakeValue, BC basicClient) {
        assert (connectionListener != null);
        assert (handshakeValue != null);
        this.connectionListener = connectionListener;
        this.handshakeValue = handshakeValue;
        this.parent = basicClient;
    }

    public static <T extends Internal.EnumLite, CC extends ClientConnection, HS extends MessageLite, HR extends MessageLite, BC extends BasicClient<T, CC, HS, HR>> Builder<T, CC, HS, HR, BC> newBuilder(RpcConnectionHandler<CC> connectionListener, HS handshakeValue, BC basicClient) {
        return new Builder(connectionListener, handshakeValue, basicClient, null);
    }

    /* synthetic */ ConnectionMultiListener(RpcConnectionHandler x0, MessageLite x1, BasicClient x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static class Builder<T extends Internal.EnumLite, CC extends ClientConnection, HS extends MessageLite, HR extends MessageLite, BC extends BasicClient<T, CC, HS, HR>> {
        private final RpcConnectionHandler<CC> connectionListener;
        private final HS handshakeValue;
        private final BC basicClient;
        boolean enableSSL = false;
        private ConnectionMultiListener<T, CC, HS, HR, BC> cml;

        private Builder(RpcConnectionHandler<CC> connectionListener, HS handshakeValue, BC basicClient) {
            this.connectionListener = connectionListener;
            this.handshakeValue = handshakeValue;
            this.basicClient = basicClient;
        }

        Builder<T, CC, HS, HR, BC> enableSSL() {
            this.enableSSL = true;
            return this;
        }

        public ConnectionMultiListener<T, CC, HS, HR, BC> build() {
            this.cml = new ConnectionMultiListener(this.connectionListener, (MessageLite)this.handshakeValue, (BasicClient)this.basicClient, null);
            ConnectionMultiListener<T, CC, HS, HR, BC> connectionMultiListener = this.cml;
            connectionMultiListener.getClass();
            this.cml.connectionHandler = connectionMultiListener.new ConnectionHandler();
            ConnectionMultiListener<T, CC, HS, HR, BC> connectionMultiListener2 = this.cml;
            connectionMultiListener2.getClass();
            ((ConnectionMultiListener)this.cml).handshakeSendHandler = connectionMultiListener2.new HandshakeSendHandler();
            if (this.enableSSL) {
                ConnectionMultiListener<T, CC, HS, HR, BC> connectionMultiListener3 = this.cml;
                connectionMultiListener3.getClass();
                ((ConnectionMultiListener)this.cml).sslConnectionHandler = connectionMultiListener3.new SSLConnectionHandler();
            }
            return this.cml;
        }

        /* synthetic */ Builder(RpcConnectionHandler x0, MessageLite x1, BasicClient x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class SSLHandshakeListener
    implements GenericFutureListener<Future<Channel>> {
        ConnectionMultiListener parent;

        SSLHandshakeListener() {
        }

        public void setParent(ConnectionMultiListener cml) {
            this.parent = cml;
        }

        @Override
        public void operationComplete(Future<Channel> future) throws Exception {
            if (this.parent != null) {
                if (!future.isSuccess()) {
                    throw new DrillException("SSL handshake failed.", future.cause());
                }
            } else {
                throw new RpcException("RPC Setup error. SSL handshake complete handler is not set up.");
            }
            Channel c = (Channel)future.get();
            this.parent.sslConnectionHandler.operationComplete(future);
            this.parent.parent.setSslChannel(c);
        }
    }

    private class HandshakeSendHandler
    implements RpcOutcomeListener<HR> {
        private HandshakeSendHandler() {
        }

        @Override
        public void failed(RpcException ex) {
            logger.debug("Failure while initiating handshake", ex);
            ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
        }

        @Override
        public void success(HR value, ByteBuf buffer) {
            try {
                List<String> serverAuthMechanisms = ConnectionMultiListener.this.parent.validateHandshake(value);
                ConnectionMultiListener.this.parent.finalizeConnection(value, ((ConnectionMultiListener)ConnectionMultiListener.this).parent.connection);
                if (serverAuthMechanisms != null) {
                    ConnectionMultiListener.this.parent.prepareSaslHandshake(ConnectionMultiListener.this.connectionListener, serverAuthMechanisms);
                } else {
                    ConnectionMultiListener.this.connectionListener.connectionSucceeded(((ConnectionMultiListener)ConnectionMultiListener.this).parent.connection);
                    logger.debug("Handshake completed successfully.");
                }
            }
            catch (NonTransientRpcException ex) {
                logger.error("Failure while validating client and server sasl compatibility", ex);
                ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.AUTHENTICATION, ex);
            }
            catch (Exception ex) {
                logger.error("Failure while validating handshake", ex);
                ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_VALIDATION, ex);
            }
        }

        @Override
        public void interrupted(InterruptedException ex) {
            logger.warn("Interrupted while waiting for handshake response", ex);
            ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
        }
    }

    private class SSLConnectionHandler
    implements GenericFutureListener<Future<Channel>> {
        private SSLConnectionHandler() {
        }

        @Override
        public void operationComplete(Future<Channel> future) throws Exception {
            ConnectionMultiListener.this.parent.send(ConnectionMultiListener.this.handshakeSendHandler, ConnectionMultiListener.this.handshakeValue, true, new ByteBuf[0]);
        }
    }

    private class ConnectionHandler
    implements GenericFutureListener<ChannelFuture> {
        private ConnectionHandler() {
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean isInterrupted = false;
            long remainingWaitTimeMills = 120000L;
            long startTime = System.currentTimeMillis();
            while (true) {
                try {
                    future.get(remainingWaitTimeMills, TimeUnit.MILLISECONDS);
                    if (future.isSuccess()) {
                        SocketAddress remote = future.channel().remoteAddress();
                        SocketAddress local = future.channel().localAddress();
                        ConnectionMultiListener.this.parent.setAddresses(remote, local);
                        if (ConnectionMultiListener.this.parent.isSslEnabled()) break;
                        ConnectionMultiListener.this.parent.send(ConnectionMultiListener.this.handshakeSendHandler, ConnectionMultiListener.this.handshakeValue, true, new ByteBuf[0]);
                        break;
                    }
                    ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, new RpcException("General connection failure."));
                }
                catch (InterruptedException interruptEx) {
                    startTime = System.currentTimeMillis();
                    isInterrupted = true;
                    if ((remainingWaitTimeMills -= System.currentTimeMillis() - startTime) >= 1L) continue;
                    ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, interruptEx);
                }
                catch (Exception ex) {
                    logger.error("Failed to establish connection", ex);
                    ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ex);
                }
                break;
            }
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

