/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.io.InputStream;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.rpc.RpcMessage;

public class InboundRpcMessage
extends RpcMessage {
    public ByteBuf pBody;
    public ByteBuf dBody;

    public InboundRpcMessage(GeneralRPCProtos.RpcMode mode, int rpcType, int coordinationId, ByteBuf pBody, ByteBuf dBody) {
        super(mode, rpcType, coordinationId);
        this.pBody = pBody;
        this.dBody = dBody;
    }

    @Override
    public int getBodySize() {
        int len = this.pBody.capacity();
        if (this.dBody != null) {
            len += this.dBody.capacity();
        }
        return len;
    }

    @Override
    void release() {
        if (this.pBody != null) {
            this.pBody.release();
        }
        if (this.dBody != null) {
            this.dBody.release();
        }
    }

    public String toString() {
        return "InboundRpcMessage [pBody=" + this.pBody + ", mode=" + this.mode + ", rpcType=" + this.rpcType + ", coordinationId=" + this.coordinationId + ", dBody=" + this.dBody + "]";
    }

    public InputStream getProtobufBodyAsIS() {
        return new ByteBufInputStream(this.pBody);
    }
}

