/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.IntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableIntVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.IntReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(IntVector.class);
    public static final int VALUE_WIDTH = 4;
    public static final int MAX_VALUE_COUNT = MAX_BUFFER_SIZE / 4;
    public static final int MAX_SCALAR_COUNT = Math.min(65536, MAX_VALUE_COUNT);
    public static final int NET_MAX_SCALAR_SIZE = 4 * MAX_SCALAR_COUNT;
    private final FieldReader reader = new IntReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = Math.min(16384, MAX_BUFFER_SIZE);
    private int allocationMonitor = 0;

    public IntVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 4;
    }

    @Override
    public int getValueCapacity() {
        return this.data.capacity() / 4;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 4L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 4);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize;
        long l = newAllocationSize = this.allocationSizeInBytes == 0 ? 256L : (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        this.reallocRaw((int)newAllocationSize);
        int halfNewCapacity = this.data.capacity() / 2;
        this.data.setZero(halfNewCapacity, halfNewCapacity);
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        if (newAllocationSize == 0) {
            throw new IllegalStateException("Attempt to reAlloc a zero-sized vector");
        }
        DrillBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = newAllocationSize;
        return newBuf;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 4;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntVector)to);
    }

    public void transferTo(IntVector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, IntVector target) {
        int startPoint = startIndex * 4;
        int sliceLength = length * 4;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return valueCount * 4;
    }

    @Override
    public int getValueWidth() {
        return 4;
    }

    public void copyFrom(int fromIndex, int thisIndex, IntVector from) {
        this.data.setInt(thisIndex * 4, from.data.getInt(fromIndex * 4));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        ((IntVector)from).data.getBytes(fromIndex * 4, this.data, toIndex * 4, 4);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        NullableIntVector dest = (NullableIntVector)nullableVector;
        dest.getMutator().fromNotNullable(this);
    }

    public static final class BufferedMutator {
        private static final int DEFAULT_BUFF_SZ = 4096;
        private final ByteBuffer buffer;
        private int currentIdx;
        private final IntVector parent;

        public BufferedMutator(int startIdx, IntVector parent) {
            this(startIdx, 4096, parent);
        }

        public BufferedMutator(int startIdx, int buffSz, IntVector parent) {
            this.buffer = ByteBuffer.allocate(buffSz);
            this.buffer.order(ByteOrder.nativeOrder());
            this.currentIdx = startIdx;
            this.parent = parent;
        }

        public void setSafe(int value) {
            if (this.buffer.remaining() < 4) {
                this.flush();
            }
            int tgtPos = this.buffer.position();
            byte[] bufferArray = this.buffer.array();
            BufferedMutator.writeInt(value, bufferArray, tgtPos);
            this.buffer.position(tgtPos + 4);
        }

        public void setSafe(int[] values, int numValues) {
            int toCopy;
            int remaining = numValues;
            byte[] bufferArray = this.buffer.array();
            int srcPos = 0;
            do {
                if (this.buffer.remaining() < 4) {
                    this.flush();
                }
                toCopy = Math.min(remaining, this.buffer.remaining() / 4);
                int tgtPos = this.buffer.position();
                int idx = 0;
                while (idx < toCopy) {
                    BufferedMutator.writeInt(values[srcPos], bufferArray, tgtPos);
                    ++idx;
                    tgtPos += 4;
                    ++srcPos;
                }
                this.buffer.position(tgtPos);
            } while ((remaining -= toCopy) > 0);
        }

        public static final void writeInt(int val, byte[] buffer, int pos) {
            DrillBuf.putInt(buffer, pos, val);
        }

        public ByteBuffer getByteBuffer() {
            return this.buffer;
        }

        public void flush() {
            int numElements = this.buffer.position() / 4;
            if (numElements == 0) {
                return;
            }
            while (this.currentIdx + numElements - 1 >= this.parent.getValueCapacity()) {
                this.parent.reAlloc();
            }
            this.parent.data.setBytes(this.currentIdx * 4, this.buffer.array(), 0, this.buffer.position());
            this.currentIdx += numElements;
            this.buffer.clear();
        }
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, int value) {
            IntVector.this.data.setInt(index * 4, value);
        }

        public void setSafe(int index, int value) {
            while (index >= IntVector.this.getValueCapacity()) {
                IntVector.this.reAlloc();
            }
            this.set(index, value);
        }

        protected void set(int index, IntHolder holder) {
            IntVector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, IntHolder holder) {
            while (index >= IntVector.this.getValueCapacity()) {
                IntVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        protected void set(int index, NullableIntHolder holder) {
            IntVector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, NullableIntHolder holder) {
            while (index >= IntVector.this.getValueCapacity()) {
                IntVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        @Override
        public void generateTestData(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = IntVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, Integer.MIN_VALUE);
                } else {
                    this.set(i, Integer.MAX_VALUE);
                }
                even = !even;
            }
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = IntVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 1);
                } else {
                    this.set(i, 0);
                }
                even = !even;
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = IntVector.this.getValueCapacity();
            int idx = 4 * valueCount;
            while (valueCount > IntVector.this.getValueCapacity()) {
                IntVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                IntVector.this.incrementAllocationMonitor();
            } else if (IntVector.this.allocationMonitor > 0) {
                IntVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(IntVector.this.data, idx);
            IntVector.this.data.writerIndex(valueCount * 4);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return IntVector.this.data.writerIndex() / 4;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public int get(int index) {
            return IntVector.this.data.getInt(index * 4);
        }

        public long getTwoAsLong(int index) {
            return IntVector.this.data.getLong(index * 4);
        }

        @Override
        public Integer getObject(int index) {
            return this.get(index);
        }

        public int getPrimitiveObject(int index) {
            return this.get(index);
        }

        public void get(int index, IntHolder holder) {
            holder.value = IntVector.this.data.getInt(index * 4);
        }

        public void get(int index, NullableIntHolder holder) {
            holder.isSet = 1;
            holder.value = IntVector.this.data.getInt(index * 4);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private IntVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new IntVector(field, allocator);
        }

        public TransferImpl(IntVector to) {
            this.to = to;
        }

        @Override
        public IntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            IntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntVector.this);
        }
    }
}

