/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import oadd.org.apache.drill.exec.expr.holders.UInt2Holder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableUInt2Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.UInt2ReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UInt2Vector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(UInt2Vector.class);
    public static final int VALUE_WIDTH = 2;
    public static final int MAX_VALUE_COUNT = MAX_BUFFER_SIZE / 2;
    public static final int MAX_SCALAR_COUNT = Math.min(65536, MAX_VALUE_COUNT);
    public static final int NET_MAX_SCALAR_SIZE = 2 * MAX_SCALAR_COUNT;
    private final FieldReader reader = new UInt2ReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = Math.min(8192, MAX_BUFFER_SIZE);
    private int allocationMonitor = 0;

    public UInt2Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 2;
    }

    @Override
    public int getValueCapacity() {
        return this.data.capacity() / 2;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 2L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 2);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize;
        long l = newAllocationSize = this.allocationSizeInBytes == 0 ? 256L : (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        this.reallocRaw((int)newAllocationSize);
        int halfNewCapacity = this.data.capacity() / 2;
        this.data.setZero(halfNewCapacity, halfNewCapacity);
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        if (newAllocationSize == 0) {
            throw new IllegalStateException("Attempt to reAlloc a zero-sized vector");
        }
        DrillBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = newAllocationSize;
        return newBuf;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 2;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((UInt2Vector)to);
    }

    public void transferTo(UInt2Vector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, UInt2Vector target) {
        int startPoint = startIndex * 2;
        int sliceLength = length * 2;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return valueCount * 2;
    }

    @Override
    public int getValueWidth() {
        return 2;
    }

    public void copyFrom(int fromIndex, int thisIndex, UInt2Vector from) {
        this.data.setChar(thisIndex * 2, from.data.getChar(fromIndex * 2));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, UInt2Vector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        ((UInt2Vector)from).data.getBytes(fromIndex * 2, this.data, toIndex * 2, 2);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        NullableUInt2Vector dest = (NullableUInt2Vector)nullableVector;
        dest.getMutator().fromNotNullable(this);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, int value) {
            UInt2Vector.this.data.setChar(index * 2, value);
        }

        public void setSafe(int index, int value) {
            while (index >= UInt2Vector.this.getValueCapacity()) {
                UInt2Vector.this.reAlloc();
            }
            this.set(index, value);
        }

        protected void set(int index, UInt2Holder holder) {
            UInt2Vector.this.data.setChar(index * 2, holder.value);
        }

        public void setSafe(int index, UInt2Holder holder) {
            while (index >= UInt2Vector.this.getValueCapacity()) {
                UInt2Vector.this.reAlloc();
            }
            this.set(index, holder);
        }

        protected void set(int index, NullableUInt2Holder holder) {
            UInt2Vector.this.data.setChar(index * 2, holder.value);
        }

        public void setSafe(int index, NullableUInt2Holder holder) {
            while (index >= UInt2Vector.this.getValueCapacity()) {
                UInt2Vector.this.reAlloc();
            }
            this.set(index, holder);
        }

        @Override
        public void generateTestData(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = UInt2Vector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 0);
                } else {
                    this.set(i, 65535);
                }
                even = !even;
            }
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = UInt2Vector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 1);
                } else {
                    this.set(i, 0);
                }
                even = !even;
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = UInt2Vector.this.getValueCapacity();
            int idx = 2 * valueCount;
            while (valueCount > UInt2Vector.this.getValueCapacity()) {
                UInt2Vector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                UInt2Vector.this.incrementAllocationMonitor();
            } else if (UInt2Vector.this.allocationMonitor > 0) {
                UInt2Vector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(UInt2Vector.this.data, idx);
            UInt2Vector.this.data.writerIndex(valueCount * 2);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return UInt2Vector.this.data.writerIndex() / 2;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public char get(int index) {
            return UInt2Vector.this.data.getChar(index * 2);
        }

        @Override
        public Character getObject(int index) {
            return Character.valueOf(this.get(index));
        }

        public char getPrimitiveObject(int index) {
            return this.get(index);
        }

        public void get(int index, UInt2Holder holder) {
            holder.value = UInt2Vector.this.data.getChar(index * 2);
        }

        public void get(int index, NullableUInt2Holder holder) {
            holder.isSet = 1;
            holder.value = UInt2Vector.this.data.getChar(index * 2);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private UInt2Vector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new UInt2Vector(field, allocator);
        }

        public TransferImpl(UInt2Vector to) {
            this.to = to;
        }

        @Override
        public UInt2Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            UInt2Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            UInt2Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, UInt2Vector.this);
        }
    }
}

