/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.math.BigDecimal;
import java.math.BigInteger;
import oadd.com.google.common.base.Charsets;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BigIntVector;
import oadd.org.apache.drill.exec.vector.BitVector;
import oadd.org.apache.drill.exec.vector.DateUtilities;
import oadd.org.apache.drill.exec.vector.DateVector;
import oadd.org.apache.drill.exec.vector.Decimal18Vector;
import oadd.org.apache.drill.exec.vector.Decimal28SparseVector;
import oadd.org.apache.drill.exec.vector.Decimal38SparseVector;
import oadd.org.apache.drill.exec.vector.Decimal9Vector;
import oadd.org.apache.drill.exec.vector.Float4Vector;
import oadd.org.apache.drill.exec.vector.Float8Vector;
import oadd.org.apache.drill.exec.vector.IntVector;
import oadd.org.apache.drill.exec.vector.IntervalDayVector;
import oadd.org.apache.drill.exec.vector.IntervalVector;
import oadd.org.apache.drill.exec.vector.IntervalYearVector;
import oadd.org.apache.drill.exec.vector.SmallIntVector;
import oadd.org.apache.drill.exec.vector.TimeStampVector;
import oadd.org.apache.drill.exec.vector.TimeVector;
import oadd.org.apache.drill.exec.vector.TinyIntVector;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.UInt2Vector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.UInt8Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.Var16CharVector;
import oadd.org.apache.drill.exec.vector.VarBinaryVector;
import oadd.org.apache.drill.exec.vector.VarCharVector;
import oadd.org.apache.drill.exec.vector.VarDecimalVector;
import oadd.org.apache.drill.exec.vector.accessor.ValueType;
import oadd.org.apache.drill.exec.vector.accessor.reader.BaseScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractFixedWidthWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.BaseVarWidthWriter;
import oadd.org.joda.time.Period;

public class ColumnAccessors {

    public static class BitColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 1;
        private final BitVector vector;

        public BitColumnWriter(ValueVector vector) {
            this.vector = (BitVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setInt(writeOffset * 1, value);
            this.vectorIndex.nextElement();
        }
    }

    public static class BitColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 1;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getInt(readOffset * 1);
        }
    }

    public static class VarDecimalColumnWriter
    extends BaseVarWidthWriter {
        private final VarDecimalVector vector;

        public VarDecimalColumnWriter(ValueVector vector) {
            super(((VarDecimalVector)vector).getOffsetVector());
            this.vector = (VarDecimalVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setBytes(byte[] value, int len) {
            int offset = this.prepareWrite(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.setNextOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void setDecimal(BigDecimal bd) {
            byte[] barr = bd.unscaledValue().toByteArray();
            int len = barr.length;
            this.setBytes(barr, len);
        }
    }

    public static class VarDecimalColumnReader
    extends BaseScalarReader.BaseVarWidthReader {
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public byte[] getBytes() {
            DrillBuf buf = this.bufferAccessor.buffer();
            long entry = this.offsetsReader.getEntry();
            return buf.unsafeGetMemory((int)(entry >> 32), (int)(entry & 0xFFFFFFFFFFFFFFFFL));
        }

        @Override
        public BigDecimal getDecimal() {
            byte[] bytes = this.getBytes();
            BigInteger unscaledValue = bytes.length == 0 ? BigInteger.ZERO : new BigInteger(bytes);
            return new BigDecimal(unscaledValue, this.type.getScale());
        }
    }

    public static class Var16CharColumnWriter
    extends BaseVarWidthWriter {
        private final Var16CharVector vector;

        public Var16CharColumnWriter(ValueVector vector) {
            super(((Var16CharVector)vector).getOffsetVector());
            this.vector = (Var16CharVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public ValueType valueType() {
            return ValueType.STRING;
        }

        @Override
        public final void setBytes(byte[] value, int len) {
            int offset = this.prepareWrite(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.setNextOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void setString(String value) {
            byte[] bytes = value.getBytes(Charsets.UTF_16);
            this.setBytes(bytes, bytes.length);
        }
    }

    public static class Var16CharColumnReader
    extends BaseScalarReader.BaseVarWidthReader {
        @Override
        public ValueType valueType() {
            return ValueType.STRING;
        }

        @Override
        public byte[] getBytes() {
            DrillBuf buf = this.bufferAccessor.buffer();
            long entry = this.offsetsReader.getEntry();
            return buf.unsafeGetMemory((int)(entry >> 32), (int)(entry & 0xFFFFFFFFFFFFFFFFL));
        }

        @Override
        public String getString() {
            return new String(this.getBytes(), Charsets.UTF_16);
        }
    }

    public static class VarCharColumnWriter
    extends BaseVarWidthWriter {
        private final VarCharVector vector;

        public VarCharColumnWriter(ValueVector vector) {
            super(((VarCharVector)vector).getOffsetVector());
            this.vector = (VarCharVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public ValueType valueType() {
            return ValueType.STRING;
        }

        @Override
        public final void setBytes(byte[] value, int len) {
            int offset = this.prepareWrite(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.setNextOffset(offset + len);
            this.vectorIndex.nextElement();
        }

        @Override
        public final void setString(String value) {
            byte[] bytes = value.getBytes(Charsets.UTF_8);
            this.setBytes(bytes, bytes.length);
        }
    }

    public static class VarCharColumnReader
    extends BaseScalarReader.BaseVarWidthReader {
        @Override
        public ValueType valueType() {
            return ValueType.STRING;
        }

        @Override
        public byte[] getBytes() {
            DrillBuf buf = this.bufferAccessor.buffer();
            long entry = this.offsetsReader.getEntry();
            return buf.unsafeGetMemory((int)(entry >> 32), (int)(entry & 0xFFFFFFFFFFFFFFFFL));
        }

        @Override
        public String getString() {
            return new String(this.getBytes(), Charsets.UTF_8);
        }
    }

    public static class VarBinaryColumnWriter
    extends BaseVarWidthWriter {
        private final VarBinaryVector vector;

        public VarBinaryColumnWriter(ValueVector vector) {
            super(((VarBinaryVector)vector).getOffsetVector());
            this.vector = (VarBinaryVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public ValueType valueType() {
            return ValueType.BYTES;
        }

        @Override
        public final void setBytes(byte[] value, int len) {
            int offset = this.prepareWrite(len);
            this.drillBuf.setBytes(offset, value, 0, len);
            this.offsetsWriter.setNextOffset(offset + len);
            this.vectorIndex.nextElement();
        }
    }

    public static class VarBinaryColumnReader
    extends BaseScalarReader.BaseVarWidthReader {
        @Override
        public ValueType valueType() {
            return ValueType.BYTES;
        }

        @Override
        public byte[] getBytes() {
            DrillBuf buf = this.bufferAccessor.buffer();
            long entry = this.offsetsReader.getEntry();
            return buf.unsafeGetMemory((int)(entry >> 32), (int)(entry & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public static class Decimal28SparseColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 20;
        private TypeProtos.MajorType type;
        private final Decimal28SparseVector vector;

        public Decimal28SparseColumnWriter(ValueVector vector) {
            this.type = vector.getField().getType();
            this.vector = (Decimal28SparseVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 20;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            int writeOffset = this.prepareWrite();
            DecimalUtility.getSparseFromBigDecimal(value, this.drillBuf, writeOffset * 20, this.type.getScale(), 5);
            this.vectorIndex.nextElement();
        }
    }

    public static class Decimal28SparseColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 20;
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public int width() {
            return 20;
        }

        @Override
        public BigDecimal getDecimal() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DecimalUtility.getBigDecimalFromSparse(buf, readOffset * 20, 5, this.type.getScale());
        }
    }

    public static class Decimal38SparseColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 24;
        private TypeProtos.MajorType type;
        private final Decimal38SparseVector vector;

        public Decimal38SparseColumnWriter(ValueVector vector) {
            this.type = vector.getField().getType();
            this.vector = (Decimal38SparseVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 24;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            int writeOffset = this.prepareWrite();
            DecimalUtility.getSparseFromBigDecimal(value, this.drillBuf, writeOffset * 24, this.type.getScale(), 6);
            this.vectorIndex.nextElement();
        }
    }

    public static class Decimal38SparseColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 24;
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public int width() {
            return 24;
        }

        @Override
        public BigDecimal getDecimal() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DecimalUtility.getBigDecimalFromSparse(buf, readOffset * 24, 6, this.type.getScale());
        }
    }

    public static class IntervalColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 16;
        private final IntervalVector vector;

        public IntervalColumnWriter(ValueVector vector) {
            this.vector = (IntervalVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 16;
        }

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public final void setPeriod(Period value) {
            int writeOffset = this.prepareWrite();
            int offset = writeOffset * 16;
            this.drillBuf.setInt(offset, DateUtilities.periodToMonths(value));
            this.drillBuf.setInt(offset + 4, value.getDays());
            this.drillBuf.setInt(offset + 8, DateUtilities.periodToMillis(value));
            this.vectorIndex.nextElement();
        }
    }

    public static class IntervalColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 16;

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public int width() {
            return 16;
        }

        @Override
        public Period getPeriod() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            int offset = readOffset * 16;
            return DateUtilities.fromInterval(buf.getInt(offset), buf.getInt(offset + 4), buf.getInt(offset + 8));
        }
    }

    public static class IntervalDayColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 12;
        private final IntervalDayVector vector;

        public IntervalDayColumnWriter(ValueVector vector) {
            this.vector = (IntervalDayVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 12;
        }

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public final void setPeriod(Period value) {
            int writeOffset = this.prepareWrite();
            int offset = writeOffset * 12;
            this.drillBuf.setInt(offset, value.getDays());
            this.drillBuf.setInt(offset + 4, DateUtilities.periodToMillis(value));
            this.vectorIndex.nextElement();
        }
    }

    public static class IntervalDayColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 12;

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public int width() {
            return 12;
        }

        @Override
        public Period getPeriod() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            int offset = readOffset * 12;
            return DateUtilities.fromIntervalDay(buf.getInt(offset), buf.getInt(offset + 4));
        }
    }

    public static class Decimal18ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private TypeProtos.MajorType type;
        private final Decimal18Vector vector;

        public Decimal18ColumnWriter(ValueVector vector) {
            this.type = vector.getField().getType();
            this.vector = (Decimal18Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setLong(writeOffset * 8, DecimalUtility.getDecimal18FromBigDecimal(value, this.type.getScale()));
            this.vectorIndex.nextElement();
        }
    }

    public static class Decimal18ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public BigDecimal getDecimal() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DecimalUtility.getBigDecimalFromPrimitiveTypes(buf.getLong(readOffset * 8), this.type.getScale());
        }
    }

    public static class TimeStampColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final TimeStampVector vector;

        public TimeStampColumnWriter(ValueVector vector) {
            this.vector = (TimeStampVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public final void setLong(long value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setLong(writeOffset * 8, value);
            this.vectorIndex.nextElement();
        }
    }

    public static class TimeStampColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getLong() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getLong(readOffset * 8);
        }
    }

    public static class DateColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final DateVector vector;

        public DateColumnWriter(ValueVector vector) {
            this.vector = (DateVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public final void setLong(long value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setLong(writeOffset * 8, value);
            this.vectorIndex.nextElement();
        }
    }

    public static class DateColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getLong() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getLong(readOffset * 8);
        }
    }

    public static class Float8ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final Float8Vector vector;

        public Float8ColumnWriter(ValueVector vector) {
            this.vector = (Float8Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DOUBLE;
        }

        @Override
        public final void setDouble(double value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setLong(writeOffset * 8, Double.doubleToRawLongBits(value));
            this.vectorIndex.nextElement();
        }
    }

    public static class Float8ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.DOUBLE;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public double getDouble() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return Double.longBitsToDouble(buf.getLong(readOffset * 8));
        }
    }

    public static class UInt8ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final UInt8Vector vector;

        public UInt8ColumnWriter(ValueVector vector) {
            this.vector = (UInt8Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public final void setLong(long value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setLong(writeOffset * 8, value);
            this.vectorIndex.nextElement();
        }
    }

    public static class UInt8ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getLong() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getLong(readOffset * 8);
        }
    }

    public static class BigIntColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 8;
        private final BigIntVector vector;

        public BigIntColumnWriter(ValueVector vector) {
            this.vector = (BigIntVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public final void setLong(long value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setLong(writeOffset * 8, value);
            this.vectorIndex.nextElement();
        }
    }

    public static class BigIntColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 8;

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getLong() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getLong(readOffset * 8);
        }
    }

    public static class Decimal9ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private TypeProtos.MajorType type;
        private final Decimal9Vector vector;

        public Decimal9ColumnWriter(ValueVector vector) {
            this.type = vector.getField().getType();
            this.vector = (Decimal9Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public final void setDecimal(BigDecimal value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setInt(writeOffset * 4, DecimalUtility.getDecimal9FromBigDecimal(value, this.type.getScale()));
            this.vectorIndex.nextElement();
        }
    }

    public static class Decimal9ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;
        private TypeProtos.MajorType type;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.type = va.type();
        }

        @Override
        public ValueType valueType() {
            return ValueType.DECIMAL;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public BigDecimal getDecimal() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DecimalUtility.getBigDecimalFromPrimitiveTypes(buf.getInt(readOffset * 4), this.type.getScale());
        }
    }

    public static class IntervalYearColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final IntervalYearVector vector;

        public IntervalYearColumnWriter(ValueVector vector) {
            this.vector = (IntervalYearVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public final void setPeriod(Period value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setInt(writeOffset * 4, value.getYears() * 12 + value.getMonths());
            this.vectorIndex.nextElement();
        }
    }

    public static class IntervalYearColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.PERIOD;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public Period getPeriod() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return DateUtilities.fromIntervalYear(buf.getInt(readOffset * 4));
        }
    }

    public static class TimeColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final TimeVector vector;

        public TimeColumnWriter(ValueVector vector) {
            this.vector = (TimeVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setInt(writeOffset * 4, value);
            this.vectorIndex.nextElement();
        }
    }

    public static class TimeColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getInt(readOffset * 4);
        }
    }

    public static class Float4ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final Float4Vector vector;

        public Float4ColumnWriter(ValueVector vector) {
            this.vector = (Float4Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.DOUBLE;
        }

        @Override
        public final void setDouble(double value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setInt(writeOffset * 4, Float.floatToRawIntBits((float)value));
            this.vectorIndex.nextElement();
        }
    }

    public static class Float4ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.DOUBLE;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public double getDouble() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return Float.intBitsToFloat(buf.getInt(readOffset * 4));
        }
    }

    public static class UInt4ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final UInt4Vector vector;

        public UInt4ColumnWriter(ValueVector vector) {
            this.vector = (UInt4Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setInt(writeOffset * 4, value);
            this.vectorIndex.nextElement();
        }
    }

    public static class UInt4ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getInt(readOffset * 4);
        }
    }

    public static class IntColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 4;
        private final IntVector vector;

        public IntColumnWriter(ValueVector vector) {
            this.vector = (IntVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setInt(writeOffset * 4, value);
            this.vectorIndex.nextElement();
        }
    }

    public static class IntColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 4;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getInt(readOffset * 4);
        }
    }

    public static class SmallIntColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 2;
        private final SmallIntVector vector;

        public SmallIntColumnWriter(ValueVector vector) {
            this.vector = (SmallIntVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setShort(writeOffset * 2, (short)value);
            this.vectorIndex.nextElement();
        }
    }

    public static class SmallIntColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 2;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getShort(readOffset * 2);
        }
    }

    public static class UInt2ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 2;
        private final UInt2Vector vector;

        public UInt2ColumnWriter(ValueVector vector) {
            this.vector = (UInt2Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setShort(writeOffset * 2, (short)value);
            this.vectorIndex.nextElement();
        }
    }

    public static class UInt2ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 2;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getShort(readOffset * 2) & 0xFFFF;
        }
    }

    public static class UInt1ColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 1;
        private final UInt1Vector vector;

        public UInt1ColumnWriter(ValueVector vector) {
            this.vector = (UInt1Vector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setByte(writeOffset * 1, (byte)value);
            this.vectorIndex.nextElement();
        }
    }

    public static class UInt1ColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 1;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getByte(readOffset * 1) & 0xFF;
        }
    }

    public static class TinyIntColumnWriter
    extends AbstractFixedWidthWriter.BaseFixedWidthWriter {
        private static final int VALUE_WIDTH = 1;
        private final TinyIntVector vector;

        public TinyIntColumnWriter(ValueVector vector) {
            this.vector = (TinyIntVector)vector;
        }

        @Override
        public BaseDataValueVector vector() {
            return this.vector;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public final void setInt(int value) {
            int writeOffset = this.prepareWrite();
            this.drillBuf.setByte(writeOffset * 1, (byte)value);
            this.vectorIndex.nextElement();
        }
    }

    public static class TinyIntColumnReader
    extends BaseScalarReader.BaseFixedWidthReader {
        private static final int VALUE_WIDTH = 1;

        @Override
        public ValueType valueType() {
            return ValueType.INTEGER;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public int getInt() {
            DrillBuf buf = this.bufferAccessor.buffer();
            int readOffset = this.vectorIndex.offset();
            return buf.getByte(readOffset * 1);
        }
    }
}

