/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.impl;

import oadd.com.google.common.base.Charsets;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VarCharVector;

public class VectorPrinter {
    public static void printOffsets(UInt4Vector vector, int start, int length) {
        VectorPrinter.header(vector, start, length);
        int i = start;
        for (int j = 0; j < length; ++j) {
            if (j > 0) {
                System.out.print(" ");
            }
            System.out.print(vector.getAccessor().get(i));
            ++i;
        }
        System.out.print("], addr = ");
        System.out.println(vector.getBuffer().addr());
    }

    public static void printStrings(VarCharVector vector, int start, int length) {
        VectorPrinter.printOffsets(vector.getOffsetVector(), start, length + 1);
        VectorPrinter.header(vector, start, length);
        System.out.println();
        int i = start;
        for (int j = 0; j < length; ++j) {
            System.out.print("  ");
            System.out.print(i);
            System.out.print(": \"");
            System.out.print(VectorPrinter.stringAt(vector, i));
            System.out.println("\"");
            ++i;
        }
        System.out.println("]");
    }

    public static void header(ValueVector vector, int start, int length) {
        System.out.print(vector.getClass());
        System.out.print(": (");
        System.out.print(start);
        System.out.print(" - ");
        System.out.print(start + length - 1);
        System.out.print("): [");
    }

    public static String stringAt(VarCharVector vector, int i) {
        return new String(vector.getAccessor().get(i), Charsets.UTF_8);
    }
}

