/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import oadd.org.apache.drill.exec.memory.BaseAllocator;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.BaseScalarWriter;

public abstract class AbstractFixedWidthWriter
extends BaseScalarWriter {
    protected int lastWriteIndex;

    @Override
    public void startWrite() {
        this.setBuffer();
        this.lastWriteIndex = -1;
    }

    public abstract int width();

    @Override
    protected final void setBuffer() {
        this.drillBuf = this.vector().getBuffer();
        this.capacity = this.drillBuf.capacity() / this.width();
    }

    protected final void mandatoryResize(int writeIndex) {
        if (writeIndex < this.capacity) {
            return;
        }
        int size = BaseAllocator.nextPowerOfTwo(Math.max((writeIndex + 1) * this.width(), 256));
        this.realloc(size);
    }

    protected final int resize(int writeIndex) {
        if (writeIndex < this.capacity) {
            return writeIndex;
        }
        int width = this.width();
        int size = BaseAllocator.nextPowerOfTwo(Math.max((writeIndex + 1) * width, 256));
        if (size <= ValueVector.MAX_BUFFER_SIZE && this.canExpand(size - this.capacity * width)) {
            this.realloc(size);
        } else {
            this.overflowed();
        }
        return this.vectorIndex.vectorIndex();
    }

    @Override
    public int lastWriteIndex() {
        return this.lastWriteIndex;
    }

    public void setLastWriteIndex(int index) {
        this.lastWriteIndex = index;
    }

    @Override
    public void skipNulls() {
        this.lastWriteIndex = this.vectorIndex.vectorIndex() - 1;
    }

    @Override
    public void restartRow() {
        this.lastWriteIndex = Math.min(this.lastWriteIndex, this.vectorIndex.vectorIndex() - 1);
    }

    @Override
    public void preRollover() {
        this.setValueCount(this.vectorIndex.rowStartIndex());
    }

    @Override
    public void postRollover() {
        int newIndex = Math.max(this.lastWriteIndex - this.vectorIndex.rowStartIndex(), -1);
        this.startWrite();
        this.lastWriteIndex = newIndex;
    }

    @Override
    public void endWrite() {
        this.setValueCount(this.vectorIndex.vectorIndex());
    }

    protected abstract void fillEmpties(int var1);

    public void setValueCount(int valueCount) {
        this.mandatoryResize(valueCount - 1);
        this.fillEmpties(valueCount);
        this.vector().getBuffer().writerIndex(valueCount * this.width());
        this.lastWriteIndex = Math.max(this.lastWriteIndex, valueCount - 1);
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.extend();
        super.dump(format);
        format.attribute("lastWriteIndex", this.lastWriteIndex).endObject();
    }

    public static abstract class BaseFixedWidthWriter
    extends AbstractFixedWidthWriter {
        private static final byte[] ZERO_BUF = new byte[256];

        protected final int prepareWrite() {
            int writeIndex = this.vectorIndex.vectorIndex();
            if (this.lastWriteIndex + 1 < writeIndex || writeIndex >= this.capacity) {
                writeIndex = this.prepareWrite(writeIndex);
            }
            this.lastWriteIndex = writeIndex;
            return writeIndex;
        }

        protected final int prepareWrite(int writeIndex) {
            writeIndex = this.resize(writeIndex);
            this.fillEmpties(writeIndex);
            return writeIndex;
        }

        @Override
        protected final void fillEmpties(int writeIndex) {
            int length;
            int width = this.width();
            int stride = ZERO_BUF.length / width;
            for (int dest = this.lastWriteIndex + 1; dest < writeIndex; dest += length) {
                length = writeIndex - dest;
                length = Math.min(length, stride);
                this.drillBuf.setBytes(dest * width, ZERO_BUF, 0, length * width);
            }
        }
    }
}

