/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.math.BigDecimal;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.ObjectType;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.UnsupportedConversionError;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import oadd.org.joda.time.Period;

public abstract class AbstractScalarWriter
implements ScalarWriter,
WriterEvents {
    protected ColumnMetadata schema;
    protected ColumnWriterIndex vectorIndex;

    @Override
    public ObjectType type() {
        return ObjectType.SCALAR;
    }

    public void bindSchema(ColumnMetadata schema) {
        this.schema = schema;
    }

    @Override
    public void bindIndex(ColumnWriterIndex vectorIndex) {
        this.vectorIndex = vectorIndex;
    }

    @Override
    public int rowStartIndex() {
        return this.vectorIndex.rowStartIndex();
    }

    @Override
    public int writeIndex() {
        return this.vectorIndex.vectorIndex();
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    public abstract BaseDataValueVector vector();

    @Override
    public void startWrite() {
    }

    @Override
    public void startRow() {
    }

    @Override
    public void endArrayValue() {
    }

    @Override
    public void saveRow() {
    }

    protected UnsupportedConversionError conversionError(String javaType) {
        return UnsupportedConversionError.writeError(this.schema(), javaType);
    }

    @Override
    public void setObject(Object value) {
        if (value == null) {
            this.setNull();
        } else if (value instanceof Integer) {
            this.setInt((Integer)value);
        } else if (value instanceof Long) {
            this.setLong((Long)value);
        } else if (value instanceof String) {
            this.setString((String)value);
        } else if (value instanceof BigDecimal) {
            this.setDecimal((BigDecimal)value);
        } else if (value instanceof Period) {
            this.setPeriod((Period)value);
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            this.setBytes(bytes, bytes.length);
        } else if (value instanceof Byte) {
            this.setInt(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.setInt(((Short)value).shortValue());
        } else if (value instanceof Double) {
            this.setDouble((Double)value);
        } else if (value instanceof Float) {
            this.setDouble(((Float)value).floatValue());
        } else {
            throw this.conversionError(value.getClass().getSimpleName());
        }
    }

    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attributeIdentity("vector", this.vector()).attribute("schema", this.vector().getField()).endObject();
    }

    public static class ScalarObjectWriter
    extends AbstractObjectWriter {
        private AbstractScalarWriter scalarWriter;

        public ScalarObjectWriter(AbstractScalarWriter scalarWriter) {
            this.scalarWriter = scalarWriter;
        }

        @Override
        public ScalarWriter scalar() {
            return this.scalarWriter;
        }

        @Override
        public WriterEvents events() {
            return this.scalarWriter;
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("scalarWriter");
            this.scalarWriter.dump(format);
            format.endObject();
        }
    }
}

