/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.ProjectionType;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.ObjectType;
import oadd.org.apache.drill.exec.vector.accessor.ObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.TupleWriter;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;

public abstract class AbstractTupleWriter
implements TupleWriter,
WriterEvents {
    protected final TupleMetadata tupleSchema;
    protected final List<AbstractObjectWriter> writers;
    protected ColumnWriterIndex vectorIndex;
    protected ColumnWriterIndex childIndex;
    protected TupleWriter.TupleWriterListener listener;
    protected WriterEvents.State state = WriterEvents.State.IDLE;

    protected AbstractTupleWriter(TupleMetadata schema, List<AbstractObjectWriter> writers) {
        this.tupleSchema = schema;
        this.writers = writers;
    }

    protected AbstractTupleWriter(TupleMetadata schema) {
        this(schema, new ArrayList<AbstractObjectWriter>());
    }

    @Override
    public ObjectType type() {
        return ObjectType.TUPLE;
    }

    protected void bindIndex(ColumnWriterIndex index, ColumnWriterIndex childIndex) {
        this.vectorIndex = index;
        this.childIndex = childIndex;
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).events().bindIndex(childIndex);
        }
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.bindIndex(index, index);
    }

    @Override
    public int rowStartIndex() {
        return this.vectorIndex.rowStartIndex();
    }

    public int addColumnWriter(AbstractObjectWriter colWriter) {
        assert (this.writers.size() == this.tupleSchema.size());
        int colIndex = this.tupleSchema.addColumn(colWriter.schema());
        this.writers.add(colWriter);
        colWriter.events().bindIndex(this.childIndex);
        if (this.state != WriterEvents.State.IDLE) {
            colWriter.events().startWrite();
            if (this.state == WriterEvents.State.IN_ROW) {
                colWriter.events().startRow();
            }
        }
        return colIndex;
    }

    @Override
    public ProjectionType projectionType(String columnName) {
        return this.listener == null ? ProjectionType.UNSPECIFIED : this.listener.projectionType(columnName);
    }

    @Override
    public int addColumn(ColumnMetadata column) {
        if (this.listener == null) {
            throw new UnsupportedOperationException("addColumn");
        }
        AbstractObjectWriter colWriter = (AbstractObjectWriter)this.listener.addColumn((TupleWriter)this, column);
        return this.addColumnWriter(colWriter);
    }

    @Override
    public int addColumn(MaterializedField field) {
        if (this.listener == null) {
            throw new UnsupportedOperationException("addColumn");
        }
        AbstractObjectWriter colWriter = (AbstractObjectWriter)this.listener.addColumn((TupleWriter)this, field);
        return this.addColumnWriter(colWriter);
    }

    @Override
    public TupleMetadata tupleSchema() {
        return this.tupleSchema;
    }

    @Override
    public int size() {
        return this.tupleSchema().size();
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public void setNull() {
        throw new IllegalStateException("Not nullable");
    }

    @Override
    public void startWrite() {
        assert (this.state == WriterEvents.State.IDLE);
        this.state = WriterEvents.State.IN_WRITE;
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).events().startWrite();
        }
    }

    @Override
    public void startRow() {
        assert (this.state == WriterEvents.State.IN_WRITE);
        this.state = WriterEvents.State.IN_ROW;
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).events().startRow();
        }
    }

    @Override
    public void endArrayValue() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).events().endArrayValue();
        }
    }

    @Override
    public void restartRow() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).events().restartRow();
        }
    }

    @Override
    public void saveRow() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).events().saveRow();
        }
        this.state = WriterEvents.State.IN_WRITE;
    }

    @Override
    public void preRollover() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).events().preRollover();
        }
    }

    @Override
    public void postRollover() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).events().postRollover();
        }
    }

    @Override
    public void endWrite() {
        assert (this.state != WriterEvents.State.IDLE);
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).events().endWrite();
        }
        this.state = WriterEvents.State.IDLE;
    }

    @Override
    public ObjectWriter column(int colIndex) {
        return this.writers.get(colIndex);
    }

    @Override
    public ObjectWriter column(String colName) {
        int index = this.tupleSchema.index(colName);
        if (index == -1) {
            throw new TupleWriter.UndefinedColumnException(colName);
        }
        return this.writers.get(index);
    }

    @Override
    public void set(int colIndex, Object value) {
        this.column(colIndex).setObject(value);
    }

    @Override
    public void setObject(Object value) {
        Object[] values = (Object[])value;
        if (values.length != this.tupleSchema.size()) {
            throw new IllegalArgumentException(String.format("Map %s has %d columns, but value array has  %d values.", this.schema().name(), this.tupleSchema.size(), values.length));
        }
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Override
    public ScalarWriter scalar(int colIndex) {
        return this.column(colIndex).scalar();
    }

    @Override
    public ScalarWriter scalar(String colName) {
        return this.column(colName).scalar();
    }

    @Override
    public TupleWriter tuple(int colIndex) {
        return this.column(colIndex).tuple();
    }

    @Override
    public TupleWriter tuple(String colName) {
        return this.column(colName).tuple();
    }

    @Override
    public ArrayWriter array(int colIndex) {
        return this.column(colIndex).array();
    }

    @Override
    public ArrayWriter array(String colName) {
        return this.column(colName).array();
    }

    @Override
    public ObjectType type(int colIndex) {
        return this.column(colIndex).type();
    }

    @Override
    public ObjectType type(String colName) {
        return this.column(colName).type();
    }

    @Override
    public int lastWriteIndex() {
        return this.vectorIndex.vectorIndex();
    }

    @Override
    public int writeIndex() {
        return this.vectorIndex.vectorIndex();
    }

    @Override
    public void bindListener(TupleWriter.TupleWriterListener listener) {
        this.listener = listener;
    }

    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attribute("vectorIndex", this.vectorIndex).attribute("state", (Object)this.state).attributeArray("writers");
        for (int i = 0; i < this.writers.size(); ++i) {
            format.element(i);
            this.writers.get(i).dump(format);
        }
        format.endArray().endObject();
    }

    public static class TupleObjectWriter
    extends AbstractObjectWriter {
        private AbstractTupleWriter tupleWriter;

        public TupleObjectWriter(AbstractTupleWriter tupleWriter) {
            this.tupleWriter = tupleWriter;
        }

        @Override
        public TupleWriter tuple() {
            return this.tupleWriter;
        }

        @Override
        public WriterEvents events() {
            return this.tupleWriter;
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("tupleWriter");
            this.tupleWriter.dump(format);
            format.endObject();
        }
    }
}

