/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import oadd.org.apache.drill.exec.memory.BaseAllocator;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.BaseScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.OffsetVectorWriterImpl;

public abstract class BaseVarWidthWriter
extends BaseScalarWriter {
    protected final OffsetVectorWriterImpl offsetsWriter;

    public BaseVarWidthWriter(UInt4Vector offsetVector) {
        this.offsetsWriter = new OffsetVectorWriterImpl(offsetVector);
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.offsetsWriter.bindIndex(index);
        super.bindIndex(index);
    }

    @Override
    public void startWrite() {
        this.setBuffer();
        this.offsetsWriter.startWrite();
    }

    @Override
    public void startRow() {
        this.offsetsWriter.startRow();
    }

    protected final int prepareWrite(int width) {
        int writeOffset = this.offsetsWriter.nextOffset();
        if (writeOffset + width < this.capacity) {
            return writeOffset;
        }
        this.resize(writeOffset + width);
        return this.offsetsWriter.nextOffset();
    }

    @Override
    protected final void setBuffer() {
        this.drillBuf = this.vector().getBuffer();
        this.capacity = this.drillBuf.capacity();
    }

    private void resize(int size) {
        if (size <= this.capacity) {
            return;
        }
        if (size < 256) {
            size = 256;
        }
        if ((size = BaseAllocator.nextPowerOfTwo(size)) <= ValueVector.MAX_BUFFER_SIZE && this.canExpand(size - this.capacity)) {
            this.realloc(size);
        } else {
            this.overflowed();
        }
    }

    @Override
    public void skipNulls() {
    }

    @Override
    public void restartRow() {
        this.offsetsWriter.restartRow();
    }

    @Override
    public int lastWriteIndex() {
        return this.offsetsWriter.lastWriteIndex();
    }

    @Override
    public final void preRollover() {
        this.vector().getBuffer().writerIndex(this.offsetsWriter.rowStartOffset());
        this.offsetsWriter.preRollover();
    }

    @Override
    public void postRollover() {
        this.setBuffer();
        this.offsetsWriter.postRollover();
    }

    @Override
    public final void endWrite() {
        this.vector().getBuffer().writerIndex(this.offsetsWriter.nextOffset());
        this.offsetsWriter.endWrite();
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.extend();
        super.dump(format);
        format.attribute("offsetsWriter");
        this.offsetsWriter.dump(format);
        format.endObject();
    }
}

