/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.StorageType;
import oadd.org.apache.hadoop.io.Writable;
import oadd.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ContentSummary
implements Writable {
    private long length;
    private long fileCount;
    private long directoryCount;
    private long quota;
    private long spaceConsumed;
    private long spaceQuota;
    private long[] typeConsumed;
    private long[] typeQuota;
    private static final String STRING_FORMAT = "%12s %12s %18s ";
    private static final String QUOTA_STRING_FORMAT = "%12s %15s ";
    private static final String SPACE_QUOTA_STRING_FORMAT = "%15s %15s ";
    private static final String HEADER = String.format("%12s %12s %18s ".replace('d', 's'), "directories", "files", "bytes");
    private static final String QUOTA_HEADER = String.format("%12s %15s %15s %15s ", "name quota", "rem name quota", "space quota", "rem space quota") + HEADER;

    @Deprecated
    public ContentSummary() {
    }

    @Deprecated
    public ContentSummary(long length, long fileCount, long directoryCount) {
        this(length, fileCount, directoryCount, -1L, length, -1L);
    }

    @Deprecated
    public ContentSummary(long length, long fileCount, long directoryCount, long quota, long spaceConsumed, long spaceQuota) {
        this.length = length;
        this.fileCount = fileCount;
        this.directoryCount = directoryCount;
        this.quota = quota;
        this.spaceConsumed = spaceConsumed;
        this.spaceQuota = spaceQuota;
    }

    private ContentSummary(long length, long fileCount, long directoryCount, long quota, long spaceConsumed, long spaceQuota, long[] typeConsumed, long[] typeQuota) {
        this.length = length;
        this.fileCount = fileCount;
        this.directoryCount = directoryCount;
        this.quota = quota;
        this.spaceConsumed = spaceConsumed;
        this.spaceQuota = spaceQuota;
        this.typeConsumed = typeConsumed;
        this.typeQuota = typeQuota;
    }

    public long getLength() {
        return this.length;
    }

    public long getDirectoryCount() {
        return this.directoryCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getQuota() {
        return this.quota;
    }

    public long getSpaceConsumed() {
        return this.spaceConsumed;
    }

    public long getSpaceQuota() {
        return this.spaceQuota;
    }

    public long getTypeQuota(StorageType type) {
        return this.typeQuota != null ? this.typeQuota[type.ordinal()] : -1L;
    }

    public long getTypeConsumed(StorageType type) {
        return this.typeConsumed != null ? this.typeConsumed[type.ordinal()] : 0L;
    }

    public boolean isTypeQuotaSet() {
        if (this.typeQuota == null) {
            return false;
        }
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            if (this.typeQuota[t.ordinal()] <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeConsumedAvailable() {
        if (this.typeConsumed == null) {
            return false;
        }
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            if (this.typeConsumed[t.ordinal()] <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    @InterfaceAudience.Private
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.length);
        out.writeLong(this.fileCount);
        out.writeLong(this.directoryCount);
        out.writeLong(this.quota);
        out.writeLong(this.spaceConsumed);
        out.writeLong(this.spaceQuota);
    }

    @Override
    @InterfaceAudience.Private
    public void readFields(DataInput in) throws IOException {
        this.length = in.readLong();
        this.fileCount = in.readLong();
        this.directoryCount = in.readLong();
        this.quota = in.readLong();
        this.spaceConsumed = in.readLong();
        this.spaceQuota = in.readLong();
    }

    public static String getHeader(boolean qOption) {
        return qOption ? QUOTA_HEADER : HEADER;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean qOption) {
        return this.toString(qOption, false);
    }

    public String toString(boolean qOption, boolean hOption) {
        String prefix = "";
        if (qOption) {
            String quotaStr = "none";
            String quotaRem = "inf";
            String spaceQuotaStr = "none";
            String spaceQuotaRem = "inf";
            if (this.quota > 0L) {
                quotaStr = this.formatSize(this.quota, hOption);
                quotaRem = this.formatSize(this.quota - (this.directoryCount + this.fileCount), hOption);
            }
            if (this.spaceQuota > 0L) {
                spaceQuotaStr = this.formatSize(this.spaceQuota, hOption);
                spaceQuotaRem = this.formatSize(this.spaceQuota - this.spaceConsumed, hOption);
            }
            prefix = String.format("%12s %15s %15s %15s ", quotaStr, quotaRem, spaceQuotaStr, spaceQuotaRem);
        }
        return prefix + String.format(STRING_FORMAT, this.formatSize(this.directoryCount, hOption), this.formatSize(this.fileCount, hOption), this.formatSize(this.length, hOption));
    }

    private String formatSize(long size, boolean humanReadable) {
        return humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1) : String.valueOf(size);
    }

    public static class Builder {
        private long length;
        private long fileCount;
        private long directoryCount;
        private long quota = -1L;
        private long spaceConsumed;
        private long spaceQuota = -1L;
        private long[] typeConsumed = new long[StorageType.values().length];
        private long[] typeQuota = new long[StorageType.values().length];

        public Builder() {
            for (int i = 0; i < this.typeQuota.length; ++i) {
                this.typeQuota[i] = -1L;
            }
        }

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder fileCount(long fileCount) {
            this.fileCount = fileCount;
            return this;
        }

        public Builder directoryCount(long directoryCount) {
            this.directoryCount = directoryCount;
            return this;
        }

        public Builder quota(long quota) {
            this.quota = quota;
            return this;
        }

        public Builder spaceConsumed(long spaceConsumed) {
            this.spaceConsumed = spaceConsumed;
            return this;
        }

        public Builder spaceQuota(long spaceQuota) {
            this.spaceQuota = spaceQuota;
            return this;
        }

        public Builder typeConsumed(long[] typeConsumed) {
            for (int i = 0; i < typeConsumed.length; ++i) {
                this.typeConsumed[i] = typeConsumed[i];
            }
            return this;
        }

        public Builder typeQuota(StorageType type, long quota) {
            this.typeQuota[type.ordinal()] = quota;
            return this;
        }

        public Builder typeConsumed(StorageType type, long consumed) {
            this.typeConsumed[type.ordinal()] = consumed;
            return this;
        }

        public Builder typeQuota(long[] typeQuota) {
            for (int i = 0; i < typeQuota.length; ++i) {
                this.typeQuota[i] = typeQuota[i];
            }
            return this;
        }

        public ContentSummary build() {
            return new ContentSummary(this.length, this.fileCount, this.directoryCount, this.quota, this.spaceConsumed, this.spaceQuota, this.typeConsumed, this.typeQuota);
        }
    }
}

