/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class IntrusiveCollection<E extends Element>
implements Collection<E> {
    private Element root = new Element(){
        Element first = this;
        Element last = this;

        @Override
        public void insertInternal(IntrusiveCollection<? extends Element> list, Element prev, Element next) {
            throw new RuntimeException("Can't insert root element");
        }

        @Override
        public void setPrev(IntrusiveCollection<? extends Element> list, Element prev) {
            Preconditions.checkState(list == IntrusiveCollection.this);
            this.last = prev;
        }

        @Override
        public void setNext(IntrusiveCollection<? extends Element> list, Element next) {
            Preconditions.checkState(list == IntrusiveCollection.this);
            this.first = next;
        }

        @Override
        public void removeInternal(IntrusiveCollection<? extends Element> list) {
            throw new RuntimeException("Can't remove root element");
        }

        @Override
        public Element getNext(IntrusiveCollection<? extends Element> list) {
            Preconditions.checkState(list == IntrusiveCollection.this);
            return this.first;
        }

        @Override
        public Element getPrev(IntrusiveCollection<? extends Element> list) {
            Preconditions.checkState(list == IntrusiveCollection.this);
            return this.last;
        }

        @Override
        public boolean isInList(IntrusiveCollection<? extends Element> list) {
            return list == IntrusiveCollection.this;
        }

        public String toString() {
            return "root";
        }
    };
    private int size = 0;
    public static final Log LOG = LogFactory.getLog(IntrusiveCollection.class);

    private Element removeElement(Element elem) {
        Element prev = elem.getPrev(this);
        Element next = elem.getNext(this);
        elem.removeInternal(this);
        prev.setNext(this, next);
        next.setPrev(this, prev);
        --this.size;
        return next;
    }

    @Override
    public Iterator<E> iterator() {
        return new IntrusiveIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        try {
            Element element = (Element)o;
            return element.isInList(this);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.size];
        int i = 0;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            ret[i++] = iter.next();
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.size) {
            return this.toArray();
        }
        int i = 0;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            array[i++] = iter.next();
        }
        return array;
    }

    @Override
    public boolean add(E elem) {
        if (elem == null) {
            return false;
        }
        if (elem.isInList(this)) {
            return false;
        }
        Element prev = this.root.getPrev(this);
        prev.setNext(this, (Element)elem);
        this.root.setPrev(this, (Element)elem);
        elem.insertInternal(this, prev, this.root);
        ++this.size;
        return true;
    }

    public boolean addFirst(Element elem) {
        if (elem == null) {
            return false;
        }
        if (elem.isInList(this)) {
            return false;
        }
        Element next = this.root.getNext(this);
        next.setPrev(this, elem);
        this.root.setNext(this, elem);
        elem.insertInternal(this, this.root, next);
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        try {
            Element elem = (Element)o;
            if (!elem.isInList(this)) {
                return false;
            }
            this.removeElement(elem);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        for (Element elem : collection) {
            if (!this.add((E)elem)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object elem : collection) {
            if (!this.remove(elem)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            Element elem = (Element)iter.next();
            if (collection.contains(elem)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public class IntrusiveIterator
    implements Iterator<E> {
        Element cur;
        Element next;

        IntrusiveIterator() {
            this.cur = IntrusiveCollection.this.root;
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.cur.getNext(IntrusiveCollection.this);
            }
            return this.next != IntrusiveCollection.this.root;
        }

        @Override
        public E next() {
            if (this.next == null) {
                this.next = this.cur.getNext(IntrusiveCollection.this);
            }
            if (this.next == IntrusiveCollection.this.root) {
                throw new NoSuchElementException();
            }
            this.cur = this.next;
            this.next = null;
            return this.cur;
        }

        @Override
        public void remove() {
            if (this.cur == null) {
                throw new IllegalStateException("Already called remove once on this element.");
            }
            this.next = IntrusiveCollection.this.removeElement(this.cur);
            this.cur = null;
        }
    }

    @InterfaceAudience.Private
    public static interface Element {
        public void insertInternal(IntrusiveCollection<? extends Element> var1, Element var2, Element var3);

        public void setPrev(IntrusiveCollection<? extends Element> var1, Element var2);

        public void setNext(IntrusiveCollection<? extends Element> var1, Element var2);

        public void removeInternal(IntrusiveCollection<? extends Element> var1);

        public Element getPrev(IntrusiveCollection<? extends Element> var1);

        public Element getNext(IntrusiveCollection<? extends Element> var1);

        public boolean isInList(IntrusiveCollection<? extends Element> var1);
    }
}

