/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.codehaus.commons.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import oadd.org.codehaus.commons.compiler.CompileException;
import oadd.org.codehaus.commons.compiler.ICookable;

public abstract class Cookable
implements ICookable {
    @Override
    public abstract void cook(String var1, Reader var2) throws CompileException, IOException;

    @Override
    public final void cook(Reader r) throws CompileException, IOException {
        this.cook(null, r);
    }

    @Override
    public final void cook(InputStream is) throws CompileException, IOException {
        this.cook(null, is);
    }

    @Override
    public final void cook(String optionalFileName, InputStream is) throws CompileException, IOException {
        this.cook(optionalFileName, is, null);
    }

    @Override
    public final void cook(InputStream is, String optionalEncoding) throws CompileException, IOException {
        this.cook(optionalEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, optionalEncoding));
    }

    @Override
    public final void cook(String optionalFileName, InputStream is, String optionalEncoding) throws CompileException, IOException {
        this.cook(optionalFileName, optionalEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, optionalEncoding));
    }

    @Override
    public void cook(String s) throws CompileException {
        this.cook((String)null, s);
    }

    @Override
    public void cook(String optionalFileName, String s) throws CompileException {
        try {
            this.cook(optionalFileName, new StringReader(s));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("SNO: StringReader throws IOException");
        }
    }

    @Override
    public final void cookFile(File file) throws CompileException, IOException {
        this.cookFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cookFile(File file, String optionalEncoding) throws CompileException, IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            this.cook(file.getAbsolutePath(), optionalEncoding == null ? new InputStreamReader(is) : new InputStreamReader((InputStream)is, optionalEncoding));
            ((InputStream)is).close();
            is = null;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ex) {}
            }
        }
    }

    @Override
    public final void cookFile(String fileName) throws CompileException, IOException {
        this.cookFile(fileName, null);
    }

    @Override
    public final void cookFile(String fileName, String optionalEncoding) throws CompileException, IOException {
        this.cookFile(new File(fileName), optionalEncoding);
    }

    public static String readString(Reader r) throws IOException {
        int count;
        StringBuilder sb = new StringBuilder();
        char[] ca = new char[4096];
        while ((count = r.read(ca)) != -1) {
            sb.append(ca, 0, count);
        }
        String s = sb.toString();
        return s;
    }
}

