/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.pcapdecoder.structure.types.impl;

import fr.bmartel.pcapdecoder.structure.BlockTypes;
import fr.bmartel.pcapdecoder.structure.options.OptionParser;
import fr.bmartel.pcapdecoder.structure.options.inter.IOptionsStatisticsHeader;
import fr.bmartel.pcapdecoder.structure.types.IPcapngType;
import fr.bmartel.pcapdecoder.structure.types.inter.IStatisticsBlock;
import fr.bmartel.pcapdecoder.utils.UtilFunctions;
import java.util.Arrays;

public class InterfaceStatisticsHeader
implements IStatisticsBlock,
IPcapngType {
    private int interfaceId = -1;
    private Long timestamp = -1L;
    private IOptionsStatisticsHeader options = null;

    public InterfaceStatisticsHeader(byte[] data, boolean isBigEndian, BlockTypes type) {
        byte[] high_timestamp;
        if (isBigEndian) {
            int i;
            this.interfaceId = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 0, 4));
            high_timestamp = Arrays.copyOfRange(data, 4, 8);
            byte[] low_timestamp = Arrays.copyOfRange(data, 8, 12);
            byte[] finalTimestamp = new byte[8];
            for (i = 0; i < 4; ++i) {
                finalTimestamp[i] = high_timestamp[i];
            }
            for (i = 0; i < 4; ++i) {
                finalTimestamp[i + 4] = low_timestamp[i];
            }
            this.timestamp = (long)UtilFunctions.convertByteArrayToLong(finalTimestamp);
        } else {
            int i;
            this.interfaceId = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 0, 4)));
            high_timestamp = UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 4, 8));
            byte[] low_timestamp = UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 8, 12));
            byte[] finalTimestamp = new byte[8];
            for (i = 0; i < 4; ++i) {
                finalTimestamp[i] = high_timestamp[i];
            }
            for (i = 0; i < 4; ++i) {
                finalTimestamp[i + 4] = low_timestamp[i];
            }
            this.timestamp = (long)UtilFunctions.convertByteArrayToLong(finalTimestamp);
        }
        if (data.length > 12) {
            OptionParser optionParser = new OptionParser(Arrays.copyOfRange(data, 12, data.length), isBigEndian, type, false);
            optionParser.decode();
            this.options = (IOptionsStatisticsHeader)optionParser.getOption();
        }
    }

    @Override
    public int getInterfaceId() {
        return this.interfaceId;
    }

    @Override
    public Long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public IOptionsStatisticsHeader getOptions() {
        return this.options;
    }
}

