/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.codahale.metrics.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oadd.com.codahale.metrics.jvm.ThreadDump;

public class ThreadDumpServlet
extends HttpServlet {
    private static final long serialVersionUID = -2690343532336103046L;
    private static final String CONTENT_TYPE = "text/plain";
    private transient ThreadDump threadDump;

    public void init() throws ServletException {
        try {
            this.threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        }
        catch (NoClassDefFoundError ncdfe) {
            this.threadDump = null;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        if (this.threadDump == null) {
            resp.getWriter().println("Sorry your runtime environment does not allow to dump threads.");
            return;
        }
        try (ServletOutputStream output = resp.getOutputStream();){
            this.threadDump.dump((OutputStream)output);
        }
    }
}

