/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.org.apache.http.client.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import oadd.org.apache.calcite.avatica.org.apache.http.Header;
import oadd.org.apache.calcite.avatica.org.apache.http.HttpEntity;
import oadd.org.apache.calcite.avatica.org.apache.http.entity.HttpEntityWrapper;
import oadd.org.apache.calcite.avatica.org.apache.http.message.BasicHeader;
import oadd.org.apache.calcite.avatica.org.apache.http.util.Args;

public class GzipCompressingEntity
extends HttpEntityWrapper {
    private static final String GZIP_CODEC = "gzip";

    public GzipCompressingEntity(HttpEntity entity) {
        super(entity);
    }

    @Override
    public Header getContentEncoding() {
        return new BasicHeader("Content-Encoding", GZIP_CODEC);
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public InputStream getContent() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull(outstream, "Output stream");
        GZIPOutputStream gzip = new GZIPOutputStream(outstream);
        this.wrappedEntity.writeTo(gzip);
        gzip.close();
    }
}

