/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.jdbc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.calcite.DataContext;
import oadd.org.apache.calcite.jdbc.CalciteSchema;
import oadd.org.apache.calcite.jdbc.DynamicSchema;
import oadd.org.apache.calcite.linq4j.tree.Expression;
import oadd.org.apache.calcite.linq4j.tree.Expressions;
import oadd.org.apache.calcite.schema.Schema;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.calcite.schema.impl.AbstractSchema;
import oadd.org.apache.calcite.util.BuiltInMethod;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.exceptions.UserExceptionUtils;
import oadd.org.apache.drill.exec.planner.sql.SchemaUtilites;
import oadd.org.apache.drill.exec.store.SchemaConfig;
import oadd.org.apache.drill.exec.store.StoragePlugin;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.SubSchemaWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRootSchema
extends DynamicSchema {
    private static final Logger logger = LoggerFactory.getLogger(DynamicRootSchema.class);
    protected SchemaConfig schemaConfig;
    protected StoragePluginRegistry storages;

    public StoragePluginRegistry getSchemaFactories() {
        return this.storages;
    }

    DynamicRootSchema(StoragePluginRegistry storages, SchemaConfig schemaConfig) {
        super(null, (Schema)new RootSchema(), "");
        this.schemaConfig = schemaConfig;
        this.storages = storages;
    }

    @Override
    protected CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        CalciteSchema retSchema = (CalciteSchema)this.getSubSchemaMap().get(schemaName);
        if (retSchema != null) {
            return retSchema;
        }
        this.loadSchemaFactory(schemaName, caseSensitive);
        retSchema = (CalciteSchema)this.getSubSchemaMap().get(schemaName);
        return retSchema;
    }

    public void loadSchemaFactory(String schemaName, boolean caseSensitive) {
        block9: {
            try {
                SchemaPlus schemaPlus = this.plus();
                StoragePlugin plugin = this.getSchemaFactories().getPlugin(schemaName);
                if (plugin != null && plugin.getConfig().isEnabled()) {
                    plugin.registerSchemas(this.schemaConfig, schemaPlus);
                    return;
                }
                List paths = SchemaUtilites.getSchemaPathAsList((String)schemaName);
                if (paths.size() != 2) break block9;
                plugin = this.getSchemaFactories().getPlugin((String)paths.get(0));
                if (plugin == null) {
                    return;
                }
                SchemaPlus firstLevelSchema = schemaPlus.getSubSchema((String)paths.get(0));
                if (firstLevelSchema == null) {
                    plugin.registerSchemas(this.schemaConfig, schemaPlus);
                    firstLevelSchema = schemaPlus.getSubSchema((String)paths.get(0));
                }
                ArrayList<SchemaPlus> secondLevelSchemas = new ArrayList<SchemaPlus>();
                for (String secondLevelSchemaName : firstLevelSchema.getSubSchemaNames()) {
                    secondLevelSchemas.add(firstLevelSchema.getSubSchema(secondLevelSchemaName));
                }
                for (SchemaPlus schema : secondLevelSchemas) {
                    oadd.org.apache.drill.exec.store.AbstractSchema drillSchema;
                    try {
                        drillSchema = (oadd.org.apache.drill.exec.store.AbstractSchema)schema.unwrap(oadd.org.apache.drill.exec.store.AbstractSchema.class);
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException(String.format("Schema '%s' is not expected under root schema", schema.getName()));
                    }
                    SubSchemaWrapper wrapper = new SubSchemaWrapper(drillSchema);
                    schemaPlus.add(wrapper.getName(), (Schema)wrapper);
                }
            }
            catch (IOException | ExecutionSetupException ex) {
                logger.warn("Failed to load schema for \"" + schemaName + "\"!", ex);
                UserException.Builder exceptBuilder = UserException.resourceError(ex).message("Failed to load schema for \"" + schemaName + "\"!", new Object[0]).addContext(ex.getClass().getName() + ": " + ex.getMessage()).addContext(UserExceptionUtils.getUserHint(ex));
                throw exceptBuilder.build(logger);
            }
        }
    }

    static class RootSchema
    extends AbstractSchema {
        RootSchema() {
        }

        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, (Expression[])new Expression[0]);
        }
    }
}

