/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression.fn;

import java.util.Comparator;
import java.util.Map;
import oadd.org.apache.commons.lang3.StringUtils;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class JodaDateValidator {
    private static final Map<PostgresDateTimeConstant, String> postgresToJodaMap = Maps.newTreeMap(new LengthDescComparator());
    public static final String POSTGRES_ESCAPE_CHARACTER = "\"";
    public static final String JODA_FULL_NAME_OF_DAY = "EEEE";
    public static final String JODA_DAY_OF_YEAR = "D";
    public static final String JODA_DAY_OF_MONTH = "d";
    public static final String JODA_DAY_OF_WEEK = "e";
    public static final String JODA_NAME_OF_MONTH = "MMMM";
    public static final String JODA_ABR_NAME_OF_MONTH = "MMM";
    public static final String JODA_YEAR = "y";
    public static final String JODA_ISO_4YEAR = "xxxx";
    public static final String JODA_ISO_3YEAR = "xxx";
    public static final String JODA_ISO_2YEAR = "xx";
    public static final String JODA_ISO_1YEAR = "x";
    public static final String JODA_FULL_ERA_NAME = "G";
    public static final String JODA_NAME_OF_DAY = "E";
    public static final String JODA_HOUR_12_NAME = "h";
    public static final String JODA_HOUR_24_NAME = "H";
    public static final String JODA_MINUTE_OF_HOUR_NAME = "m";
    public static final String JODA_SECOND_OF_MINUTE_NAME = "ss";
    public static final String JODA_MILLISECOND_OF_MINUTE_NAME = "SSS";
    public static final String JODA_WEEK_OF_YEAR = "w";
    public static final String JODA_MONTH = "MM";
    public static final String JODA_HALFDAY = "aa";
    public static final String JODA_ESCAPE_CHARACTER = "'";
    public static final String EMPTY_STRING = "";

    public static String toJodaFormat(String pattern) {
        int minPos;
        StringBuilder builder = new StringBuilder(pattern.replaceAll(POSTGRES_ESCAPE_CHARACTER, JODA_ESCAPE_CHARACTER));
        int start = 0;
        do {
            minPos = builder.length();
            PostgresDateTimeConstant firstMatch = null;
            for (PostgresDateTimeConstant postgresPattern : postgresToJodaMap.keySet()) {
                int pos;
                if (postgresPattern.hasCamelCasing() && (pos = builder.indexOf(StringUtils.capitalize(postgresPattern.getName()), start)) >= 0 && pos < minPos) {
                    firstMatch = postgresPattern;
                    minPos = pos;
                    if (minPos == start) break;
                }
                if ((pos = builder.indexOf(postgresPattern.getName().toLowerCase(), start)) >= 0 && pos < minPos) {
                    firstMatch = postgresPattern;
                    minPos = pos;
                    if (minPos == start) break;
                }
                if ((pos = builder.indexOf(postgresPattern.getName().toUpperCase(), start)) < 0 || pos >= minPos) continue;
                firstMatch = postgresPattern;
                minPos = pos;
                if (minPos != start) continue;
                break;
            }
            if (minPos >= builder.length() || firstMatch == null) continue;
            String jodaToken = postgresToJodaMap.get((Object)firstMatch);
            if (StringUtils.countMatches(builder.subSequence(0, minPos), JODA_ESCAPE_CHARACTER) % 2 == 0) {
                int offset = minPos + firstMatch.getName().length();
                builder.replace(minPos, offset, jodaToken);
                start = minPos + jodaToken.length();
                continue;
            }
            int endEscapeCharacter = builder.indexOf(JODA_ESCAPE_CHARACTER, minPos);
            if (endEscapeCharacter < 0) break;
            start = endEscapeCharacter;
        } while (minPos < builder.length());
        return builder.toString();
    }

    static {
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_FULL_NAME_OF_DAY, JODA_FULL_NAME_OF_DAY);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_DAY_OF_YEAR, JODA_DAY_OF_YEAR);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_DAY_OF_MONTH, JODA_DAY_OF_MONTH);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_DAY_OF_WEEK, JODA_DAY_OF_WEEK);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_NAME_OF_MONTH, JODA_NAME_OF_MONTH);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_ABR_NAME_OF_MONTH, JODA_ABR_NAME_OF_MONTH);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_FULL_ERA_NAME, JODA_FULL_ERA_NAME);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_NAME_OF_DAY, JODA_NAME_OF_DAY);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_HOUR_12_NAME, JODA_HOUR_12_NAME);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_HOUR_12_OTHER_NAME, JODA_HOUR_12_NAME);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_HOUR_24_NAME, JODA_HOUR_24_NAME);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_MINUTE_OF_HOUR_NAME, JODA_MINUTE_OF_HOUR_NAME);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_SECOND_OF_MINUTE_NAME, JODA_SECOND_OF_MINUTE_NAME);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_MILLISECOND_OF_MINUTE_NAME, JODA_MILLISECOND_OF_MINUTE_NAME);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_WEEK_OF_YEAR, JODA_WEEK_OF_YEAR);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_MONTH, JODA_MONTH);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_HALFDAY_AM, JODA_HALFDAY);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_HALFDAY_PM, JODA_HALFDAY);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_ISO_WEEK_OF_YEAR, JODA_WEEK_OF_YEAR);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_YEAR, JODA_YEAR);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_ISO_1YEAR, JODA_ISO_1YEAR);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_ISO_2YEAR, JODA_ISO_2YEAR);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_ISO_3YEAR, JODA_ISO_3YEAR);
        postgresToJodaMap.put(PostgresDateTimeConstant.POSTGRES_ISO_4YEAR, JODA_ISO_4YEAR);
        postgresToJodaMap.put(PostgresDateTimeConstant.PREFIX_FM, EMPTY_STRING);
        postgresToJodaMap.put(PostgresDateTimeConstant.PREFIX_FX, EMPTY_STRING);
        postgresToJodaMap.put(PostgresDateTimeConstant.PREFIX_TM, EMPTY_STRING);
    }

    private static class LengthDescComparator
    implements Comparator<PostgresDateTimeConstant> {
        private LengthDescComparator() {
        }

        @Override
        public int compare(PostgresDateTimeConstant o1, PostgresDateTimeConstant o2) {
            int result = o2.getName().length() - o1.getName().length();
            if (result == 0) {
                return o1.getName().compareTo(o2.getName());
            }
            return result;
        }
    }

    public static enum PostgresDateTimeConstant {
        POSTGRES_FULL_NAME_OF_DAY(true, "day"),
        POSTGRES_DAY_OF_YEAR(false, "ddd"),
        POSTGRES_DAY_OF_MONTH(false, "dd"),
        POSTGRES_DAY_OF_WEEK(false, "d"),
        POSTGRES_NAME_OF_MONTH(true, "month"),
        POSTGRES_ABR_NAME_OF_MONTH(true, "mon"),
        POSTGRES_YEAR(false, "y"),
        POSTGRES_ISO_4YEAR(false, "iyyy"),
        POSTGRES_ISO_3YEAR(false, "iyy"),
        POSTGRES_ISO_2YEAR(false, "iy"),
        POSTGRES_ISO_1YEAR(false, "i"),
        POSTGRES_FULL_ERA_NAME(false, "ee"),
        POSTGRES_NAME_OF_DAY(true, "dy"),
        POSTGRES_HOUR_12_NAME(false, "hh"),
        POSTGRES_HOUR_12_OTHER_NAME(false, "hh12"),
        POSTGRES_HOUR_24_NAME(false, "hh24"),
        POSTGRES_MINUTE_OF_HOUR_NAME(false, "mi"),
        POSTGRES_SECOND_OF_MINUTE_NAME(false, "ss"),
        POSTGRES_MILLISECOND_OF_MINUTE_NAME(false, "ms"),
        POSTGRES_WEEK_OF_YEAR(false, "ww"),
        POSTGRES_ISO_WEEK_OF_YEAR(false, "iw"),
        POSTGRES_MONTH(false, "mm"),
        POSTGRES_HALFDAY_AM(false, "am"),
        POSTGRES_HALFDAY_PM(false, "pm"),
        PREFIX_FM(false, "fm"),
        PREFIX_FX(false, "fx"),
        PREFIX_TM(false, "tm");

        private final boolean hasCamelCasing;
        private final String name;

        private PostgresDateTimeConstant(boolean hasCamelCasing, String name) {
            this.hasCamelCasing = hasCamelCasing;
            this.name = name;
        }

        public boolean hasCamelCasing() {
            return this.hasCamelCasing;
        }

        public String getName() {
            return this.name;
        }
    }
}

