/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import oadd.org.apache.drill.exec.record.metadata.Propertied;

public class AbstractPropertied
implements Propertied {
    private Map<String, String> properties;

    protected AbstractPropertied() {
    }

    protected AbstractPropertied(AbstractPropertied from) {
        this.setProperties(from.properties);
    }

    protected boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.properties().putAll(properties);
        }
    }

    @Override
    public Map<String, String> properties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public String property(String key) {
        return this.property(key, null);
    }

    @Override
    public String property(String key, String defValue) {
        if (this.properties == null) {
            return defValue;
        }
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        if (value != null) {
            this.properties().put(key, value);
        } else if (this.properties != null) {
            this.properties.remove(key);
        }
    }

    @Override
    public boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(this.property(key, Boolean.FALSE.toString()));
    }
}

