/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MetadataUtils;
import oadd.org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;

public class SchemaPathUtils {
    private SchemaPathUtils() {
    }

    public static ColumnMetadata getColumnMetadata(SchemaPath schemaPath, TupleMetadata schema) {
        PathSegment.NameSegment colPath = schemaPath.getUnIndexed().getRootSegment();
        ColumnMetadata colMetadata = schema.metadata(colPath.getPath());
        while (!colPath.isLastPath() && colMetadata != null) {
            if (!colMetadata.isMap()) {
                colMetadata = null;
                break;
            }
            colPath = (PathSegment.NameSegment)colPath.getChild();
            colMetadata = colMetadata.mapSchema().metadata(colPath.getPath());
        }
        return colMetadata;
    }

    public static void addColumnMetadata(TupleMetadata schema, SchemaPath schemaPath, TypeProtos.MajorType type) {
        ColumnMetadata colMetadata;
        PathSegment.NameSegment colPath = schemaPath.getUnIndexed().getRootSegment();
        while (!colPath.isLastPath()) {
            colMetadata = schema.metadata(colPath.getPath());
            if (colMetadata == null) {
                colMetadata = MetadataUtils.newMap(colPath.getPath(), null);
                schema.addColumn(colMetadata);
            }
            if (!colMetadata.isMap()) {
                throw new DrillRuntimeException(String.format("Expected map, but was %s", colMetadata.majorType()));
            }
            schema = colMetadata.mapSchema();
            colPath = (PathSegment.NameSegment)colPath.getChild();
        }
        colMetadata = schema.metadata(colPath.getPath());
        if (colMetadata == null) {
            schema.addColumn(new PrimitiveColumnMetadata(MaterializedField.create(colPath.getPath(), type)));
        } else if (!colMetadata.majorType().equals(type)) {
            throw new DrillRuntimeException(String.format("Types mismatch: existing type: %s, new type: %s", colMetadata.majorType(), type));
        }
    }
}

