/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resourcemgr.config.selectors;

import avro.shaded.com.google.common.annotations.VisibleForTesting;
import oadd.com.typesafe.config.Config;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.resourcemgr.config.exception.RMConfigException;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.AbstractResourcePoolSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.ResourcePoolSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.ResourcePoolSelectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotEqualSelector
extends AbstractResourcePoolSelector {
    private static final Logger logger = LoggerFactory.getLogger(NotEqualSelector.class);
    private final ResourcePoolSelector poolSelector;

    NotEqualSelector(Config selectorValue) throws RMConfigException {
        super(ResourcePoolSelector.SelectorType.NOT_EQUAL);
        this.poolSelector = ResourcePoolSelectorFactory.createSelector(selectorValue);
    }

    @Override
    public boolean isQuerySelected(QueryContext queryContext) {
        logger.debug("Query {} is evaluated for not_equal of selector type {}", (Object)queryContext.getQueryId(), (Object)this.poolSelector.getSelectorType().toString());
        return !this.poolSelector.isQuerySelected(queryContext);
    }

    @VisibleForTesting
    public ResourcePoolSelector getPoolSelector() {
        return this.poolSelector;
    }

    @Override
    public String toString() {
        return "{ SelectorType: " + super.toString() + ", of selector " + this.poolSelector.toString() + " }";
    }
}

